/*
 * Decompiled with CFR 0.152.
 */
import edu.cmu.meteor.aligner.Aligner;
import edu.cmu.meteor.aligner.Alignment;
import edu.cmu.meteor.aligner.PartialAlignment;
import edu.cmu.meteor.util.Constants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Matcher {
    public static void main(String[] stringArray) throws Exception {
        int n;
        Object object;
        Comparator<PartialAlignment> comparator;
        if (stringArray.length < 2) {
            System.out.println("Meteor Aligner version 1.5");
            System.out.println("Usage: java -Xmx2G -cp meteor-*.jar Matcher <test> <reference> [options]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("-l language                     One of: en da de es fi fr hu it nl no pt ro ru se tr");
            System.out.println("-m 'module1 module2 ...'        Specify modules (overrides default)");
            System.out.println("                                  One of: exact stem synonym paraphrase");
            System.out.println("-t type                         Alignment type (coverage vs accuracy)");
            System.out.println("                                  One of: maxcov maxacc");
            System.out.println("-x beamSize                     Keep speed reasonable");
            System.out.println("-d synonymDirectory             (if not default)");
            System.out.println("-a paraphraseFile               (if not default)");
            System.out.println("-stdio                          Read lines from stdin");
            System.out.println("                                  sentence 1 ||| sentence 2");
            System.out.println("                                  use \"-\" for test and reference (Matcher - - -stdio)");
            System.out.println();
            System.out.println("See README file for examples");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = false;
        Properties properties = new Properties();
        int n2 = 2;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-l")) {
                properties.setProperty("language", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-x")) {
                properties.setProperty("beamSize", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-d")) {
                properties.setProperty("synDir", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-a")) {
                properties.setProperty("paraFile", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-m")) {
                properties.setProperty("modules", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-t")) {
                properties.setProperty("type", stringArray[n2 + 1]);
                n2 += 2;
                continue;
            }
            if (stringArray[n2].equals("-stdio")) {
                bl = true;
                ++n2;
                continue;
            }
            System.err.println("Unknown option \"" + stringArray[n2] + "\"");
            System.exit(1);
        }
        String string3 = properties.getProperty("language");
        if (string3 == null) {
            string3 = "english";
        }
        string3 = Constants.normLanguageName(string3);
        String string4 = properties.getProperty("synDir");
        URL uRL = string4 == null ? Constants.DEFAULT_SYN_DIR_URL : new File(string4).toURI().toURL();
        String string5 = properties.getProperty("paraFile");
        URL uRL2 = string5 == null ? Constants.getDefaultParaFileURL(Constants.getLanguageID(string3)) : new File(string5).toURI().toURL();
        String string6 = properties.getProperty("beamSize");
        int n3 = 0;
        n3 = string6 == null ? 40 : Integer.parseInt(string6);
        String string7 = properties.getProperty("modules");
        if (string7 == null) {
            string7 = "exact stem synonym paraphrase";
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string7);
        while (stringTokenizer.hasMoreTokens()) {
            int n4 = Constants.getModuleID(stringTokenizer.nextToken());
            arrayList.add(n4);
        }
        String string8 = properties.getProperty("type");
        if (string8 == null) {
            string8 = "maxcov";
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        if (string8.equals("maxcov")) {
            comparator = Constants.PARTIAL_COMPARE_TOTAL;
            object = arrayList.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                if (n == 0) {
                    arrayList2.add(1.0);
                    continue;
                }
                if (n == 1) {
                    arrayList2.add(0.5);
                    continue;
                }
                if (n == 2) {
                    arrayList2.add(0.5);
                    continue;
                }
                arrayList2.add(0.5);
            }
        } else {
            comparator = Constants.PARTIAL_COMPARE_TOTAL_ALL;
            object = arrayList.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                if (n == 0) {
                    arrayList2.add(1.0);
                    continue;
                }
                if (n == 1) {
                    arrayList2.add(1.0);
                    continue;
                }
                if (n == 2) {
                    arrayList2.add(1.0);
                    continue;
                }
                arrayList2.add(0.0);
            }
        }
        object = new Aligner(string3, arrayList, arrayList2, n3, Constants.getDefaultWordFileURL(Constants.getLanguageID(string3)), uRL, uRL2, comparator);
        if (bl) {
            String string9;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            while ((string9 = bufferedReader.readLine()) != null) {
                int n5 = string9.indexOf(" ||| ");
                if (n5 == -1) {
                    System.err.println("Format error, use: sentence 1 ||| sentence 2");
                    continue;
                }
                Alignment alignment = ((Aligner)object).align(string9.substring(0, n5), string9.substring(n5 + 5));
                System.out.println(alignment.toString());
            }
        } else {
            String string10;
            BufferedReader bufferedReader = null;
            BufferedReader bufferedReader2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
                bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "UTF-8"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            int n6 = 0;
            while ((string10 = bufferedReader.readLine()) != null) {
                String string11 = bufferedReader2.readLine();
                if (string11 == null) {
                    System.err.println("Error: files not of same length.");
                    System.exit(1);
                }
                ++n6;
                try {
                    Alignment alignment = ((Aligner)object).align(string10, string11);
                    System.out.println(alignment.toString("Alignment " + n6));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

