import json 

def operate1():
    with open("check4save_result.json","r") as f:
        dataset = json.load(f)
        print(f"length of data is {len(dataset)}")

    new_dataset = []
    hit_count = 0
    for item in dataset:
        code_list = item["code_list"]
        removed_code_list = []
        for each_code in code_list:
            # remove "if __name__ == \"__main__\":\n    main()"
            if "if __name__ == \"__main__\":\n    main()" in each_code:
                each_code_replaced = each_code.replace("if __name__ == \"__main__\":\n    main()","main()")
                hit_count += 1
                removed_code_list.append(each_code_replaced)
            else:
                removed_code_list.append(each_code)
        
        item["code_list"] = removed_code_list
        new_dataset.append(item)
    
    print(f"hit count = {hit_count}")
    print(f"new length of data is {len(new_dataset)}")

    with open("check4save_result_removed2.json","w") as g:
        json.dump(new_dataset, g, indent=4)


def operate2():
    question = "You are given a positive integer N, and an integer A_{x,y,z} for each triple of integers (x, y, z) such that 1 \\leq x, y, z \\leq N.\nYou will be given Q queries in the following format, which must be processed in order.\nFor the i-th query (1 \\leq i \\leq Q), you are given a tuple of integers (Lx_i, Rx_i, Ly_i, Ry_i, Lz_i, Rz_i) such that 1 \\leq Lx_i \\leq Rx_i \\leq N, 1 \\leq Ly_i \\leq Ry_i \\leq N, and 1 \\leq Lz_i \\leq Rz_i \\leq N. Find:\n\\displaystyle{\\sum_{x=Lx_i}^{Rx_i} \\sum_{y=Ly_i}^{Ry_i} \\sum_{z=Lz_i}^{Rz_i} A_{x,y,z}}.\n\nInput\n\nThe input is given from Standard Input in the following format:\nN\r\nA_{1,1,1} A_{1,1,2} \\ldots A_{1,1,N}\r\nA_{1,2,1} A_{1,2,2} \\ldots A_{1,2,N}\r\n\\vdots\r\nA_{1,N,1} A_{1,N,2} \\ldots A_{1,N,N}\r\nA_{2,1,1} A_{2,1,2} \\ldots A_{2,1,N}\r\nA_{2,2,1} A_{2,2,2} \\ldots A_{2,2,N}\r\n\\vdots\r\nA_{2,N,1} A_{2,N,2} \\ldots A_{2,N,N}\r\n\\vdots\r\nA_{N,1,1} A_{N,1,2} \\ldots A_{N,1,N}\r\nA_{N,2,1} A_{N,2,2} \\ldots A_{N,2,N}\r\n\\vdots\r\nA_{N,N,1} A_{N,N,2} \\ldots A_{N,N,N}\r\nQ\r\nLx_1 Rx_1 Ly_1 Ry_1 Lz_1 Rz_1\r\nLx_2 Rx_2 Ly_2 Ry_2 Lz_2 Rz_2\r\n\\vdots\r\nLx_Q Rx_Q Ly_Q Ry_Q Lz_Q Rz_Q\n\nOutput\n\nPrint Q lines.\r\nThe i-th line should contain the answer to the i-th query.\n\nConstraints\n\n\n- 1 \\leq N \\leq 100\n- 1 \\leq Q \\leq 2 \\times 10^{5}\n- 0 \\leq A_{x,y,z} \\leq 999 (1 \\leq x, y, z \\leq N)\n- 1 \\leq Lx_i \\leq Rx_i \\leq N (1 \\leq i \\leq Q)\n- 1 \\leq Ly_i \\leq Ry_i \\leq N (1 \\leq i \\leq Q)\n- 1 \\leq Lz_i \\leq Rz_i \\leq N (1 \\leq i \\leq Q)\n- All input values are integers.\n\nSample Input 1\n\n2\r\n1 2\r\n3 4\r\n5 6\r\n7 8\r\n2\r\n1 2 2 2 1 1\r\n2 2 1 2 1 2\n\nSample Output 1\n\n10\r\n26\r\n\nFor the 1st query, the sought value is A_{1,2,1} + A_{2,2,1} = 3 + 7 = 10. Thus, print 10.\nFor the 2nd query, the sought value is A_{2,1,1} + A_{2,1,2} + A_{2,2,1} + A_{2,2,2} = 5 + 6 + 7 + 8 = 26. Thus, print 26.\n\nSample Input 2\n\n3\r\n733 857 714\r\n956 208 257\r\n123 719 648\r\n840 881 245\r\n245 112 746\r\n306 942 694\r\n58 870 849\r\n13 208 789\r\n687 906 783\r\n8\r\n3 3 3 3 1 1\r\n1 3 2 3 3 3\r\n2 2 2 3 1 1\r\n1 3 1 1 1 1\r\n2 3 2 3 2 3\r\n1 2 1 1 1 2\r\n3 3 2 2 1 3\r\n1 2 2 3 2 3\n\nSample Output 2\n\n687\r\n3917\r\n551\r\n1631\r\n5180\r\n3311\r\n1010\r\n4326"
    code = "import sys\n\ndef main():\n    import sys\n    input = sys.stdin.read().split()\n    index = 0\n    N = int(input[index])\n    index += 1\n    A = [[[0] * N for _ in range(N)] for _ in range(N)]\n    for x in range(N):\n        for y in range(N):\n            for z in range(N):\n                A[x][y][z] = int(input[index])\n                index += 1\n    Q = int(input[index])\n    index += 1\n    results = []\n    for _ in range(Q):\n        Lx = int(input[index]) - 1\n        Rx = int(input[index + 1]) - 1\n        Ly = int(input[index + 2]) - 1\n        Ry = int(input[index + 3]) - 1\n        Lz = int(input[index + 4]) - 1\n        Rz = int(input[index + 5]) - 1\n        index += 6\n        total = 0\n        for x in range(Lx, Rx + 1):\n            for y in range(Ly, Ry + 1):\n                for z in range(Lz, Rz + 1):\n                    total += A[x][y][z]\n        results.append(total)\n    for result in results:\n        print(result)\n\n"
    input = "2\\n1 2\\n3 4\\n5 6\\n7 8\\n2\\n1 2 2 2 1 1\\n2 2 1 2 1 2\\n"

    print(f"question = {question}")
    print(f"code = {code}")
    print(f"input = {input}")

if __name__ == "__main__":
    operate1()

    # operate2()
