import os
import sys
current_file_path = os.path.abspath(__file__)
parent_dir = os.path.dirname(os.path.dirname(current_file_path))
project_root_dir = os.path.dirname(parent_dir)
sys.path.append(parent_dir)
sys.path.append(project_root_dir)

from metrics.registry import DETECTOR
from .utils import slowfast

from .facexray_detector import FaceXrayDetector
from .meso4Inception_detector import Meso4InceptionDetector
from .core_detector import CoreDetector
from .capsule_net_detector import CapsuleNetDetector
from .ucf_detector import UCFDetector
from .recce_detector import RecceDetector
from .fwa_detector import FWADetector
from .ffd_detector import FFDDetector
from .videomae_detector import VideoMAEDetector
from .clip_detector import CLIPDetector
from .timesformer_detector import TimeSformerDetector
from .xclip_detector import XCLIPDetector
from .sbi_detector import SBIDetector
from .ftcn_detector import FTCNDetector
from .i3d_detector import I3DDetector
from .altfreezing_detector import AltFreezingDetector
from .stil_detector import STILDetector
from .lsda_detector import LSDADetector
from .sladd_detector import SLADDXceptionDetector
from .pcl_xception_detector import PCLXceptionDetector
from .iid_detector import IIDDetector
from .lrl_detector import LRLDetector
from .rfm_detector import RFMDetector
from .uia_vit_detector import UIAViTDetector
from .multi_attention_detector import MultiAttentionDetector
from .sia_detector import SIADetector
from .tall_detector import TALLDetector

# NOTE: The imports above this line are legacy models from DeepfakeBench
# and are not directly relevant to the current paper.
# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------
# Baseline Models Used in Our Paper
# ------------------------------------------------------------------------------

from .xception_detector import XceptionDetector
from .efficientnetb4_detector import EfficientDetector
from .resnet34_detector import ResnetDetector
from .meso4_detector import Meso4Detector

# ------------------------------------------------------------------------------
# Frequency-Based Models Evaluated in Our Paper
# ------------------------------------------------------------------------------

from .f3net_detector import F3netDetector
from .srm_detector import SRMDetector
from .spsl_detector import SpslDetector

# ------------------------------------------------------------------------------
# Method 1: Direct Concatenation of Handcrafted Features
# ------------------------------------------------------------------------------

from .lbp_detector import LBP4ChDetector
from .wdf_detector import Wavelet4ChDetector

# ------------------------------------------------------------------------------
# Method 2: Lightweight Fusion of Wavelet Denoised Features
# ------------------------------------------------------------------------------

# LFWS: Wavelet + SPSL Fusion Models
from .lfws_xception import WaveletPhase_xception_Detector
from .lfws_efficient import WaveletPhase_efficient_Detector
from .lfws_resnet import WaveletPhase_ResNet34_Detector
from .lfws_meso4 import WaveletPhase_Meso4_Detector

# LFWL: Wavelet + LBP Fusion Models
from .lfwl_xception import WaveletLBP4chDetector
from .lfwl_efficient import WaveletLBP_efficient_Detector
from .lfwl_resenet import WaveletLBP_ResNet34_Detector
from .lfwl_meso4 import WaveletLBP_Meso4_Detector


