# 🚀 Quick‑Start: Evaluate Our Models with DeepfakeBench

Our detectors, YAML configs, and pre‑trained checkpoints are fully compatible with  
[SCLBD / DeepfakeBench](https://github.com/SCLBD/DeepfakeBench).

### Steps to Reproduce Our Results  at a Glance
| # | Action |
|---|--------|
| **1** | Clone DeepfakeBench |
| **2** | Drop‑in our detector code & configs |
| **3** | Download and unzip model checkpoints (`training.zip`)- Due to double blind policy, we donn't offer pretrained models. |
| **4** | *(If needed)* Download / preprocess the eight evaluation datasets |
| **5** | Run `test.py` with the proper `*.yaml` + `ckpt_best.pth` |

---


## 1. Clone DeepfakeBench

```bash
git clone https://github.com/SCLBD/DeepfakeBench.git
cd DeepfakeBench
```

---

## 2. Add Our Detector Code & Configs

```bash
# still inside DeepfakeBench/
git clone https://github.com/Sunghwan0112/Deepfake_detection_NeurIPS.git tmp_repo

cp -r tmp_repo/training/detectors           training/
cp -r tmp_repo/training/config/detector     training/config/
```
You should now see files such as
```
training/detectors/lfws_xception.py
training/config/detector/Method2/lfws_xception.yaml
```

---

## 3. Download & Unzip Checkpoints

```bash
pip install gdown
gdown --id 1Dx8HURjFLtoMDMb26RXXXTup8iGT0BNy -O training.zip

mkdir -p logs
unzip training.zip -d logs/
```
This populates `logs/training/…/ckpt_best.pth`.

---

## 4. Dataset Setup & Pre‑processing

#### Ready-made, Pre-cropped Sets
In our experiments, we downloaded and pre-processed the raw datasets ourselves.  
However, for convenience, **DeepfakeBench also provides all eight datasets in pre-cropped form**, which can be used directly without additional processing:

| Type | Links | Notes |
|------|-------|-------|
| **RGB (cropped)** | [Google Drive](https://drive.google.com/drive/folders/1N4X3rvx9IhmkEZK-KIk4OxBrQb9BRUcs?usp=drive_link) · [Baidu pwd `ogjn`](https://pan.baidu.com/s/1NAMUHcZvsIm7l6hMHeEQjQ?pwd=ogjn) | Cropped images from videos |
| **LMDB** | [Baidu pwd `g3gj`](https://pan.baidu.com/s/1riMCN5iXTJ2g9fQjtlZswg?pwd=g3gj) | Optional high‑speed format |
| **JSON splits** | [Google Drive](https://drive.google.com/drive/folders/1ZV3fz5MZZU5BTB5neziN6i8Yv0Z21_LO?usp=drive_link) · [Baidu pwd `dcwv`](https://pan.baidu.com/s/1d7PTV2GK-fpGibcbtnQDqQ?pwd=dcwv) | Train/val/test files |

---


## 5. Run an Example Evaluation
```bash
python test.py \
  --detector_path training/config/detector/Baseline_models/xception.yaml \
  --weights_path logs/training/Trained_on_FaceForensics++/Baseline_models/xception_baseline_FaceForensics++/test/avg/ckpt_best.pth \
  --test_dataset   "FaceForensics++" "FF-F2F" "FF-DF" "FF-FS" "FF-NT" \
                   "FaceShifter" "DeepFakeDetection" "Celeb-DF-v1" "Celeb-DF-v2" \
                   "DFDC" "DFDCP" "UADFV"
```
Swap `--detector_path` / `--weights_path` for any other model (e.g. `Method2/lfws_xception.yaml`, `Freq-based_models/srm.yaml`, …).

---

## 📁 Directory Layout After Setup

### 1. Checkpoints (`logs/…/ckpt_best.pth`)
Checkpoints are not shared via external links during review
```
DeepfakeBench/logs/
└── training/
    ├── Trained_on_DFDCP/
    │   ├── Baseline_models/
    │   │   ├── xception_baseline_DFDCP/
    │   │   │   └── test/avg/ckpt_best.pth
    │   │   └── … (other backbones)
    │   ├── Freq-based_models/
    │   │   ├── f3net_DFDCP/ …
    │   ├── Method1/
    │   └── Method2/
    └── Trained_on_FaceForensics++/
        ├── Alternative_backbones/
        ├── Baseline_models/
        ├── Freq-based_models/
        ├── Method1/
        └── Method2/
```

### 2. Detector Code & Configs (copied in **Step 2**)
```
DeepfakeBench/training/
├── detectors/
│   ├── lfws_xception.py
│   ├── lfwl_xception.py
│   └── …
└── config/
    └── detector/
        ├── Baseline_models/
        │   ├── xception.yaml
        │   ├── resnet34.yaml
        │   └── …
        ├── Freq-based_models/
        │   ├── srm.yaml
        │   └── …
        ├── Method1/
        │   ├── lbp.yaml
        │   └── wdf.yaml
        ├── Method2/
        │   ├── lfws_xception.yaml
        │   └── lfwl_xception.yaml
        └── Alternative_backbones/
            ├── lfws_efficient.yaml
            └── …
```
