#!/bin/bash

CUDA_VISIBLE_DEVICES=1 torchrun \
  --master_port=8008 \
  basicsr/test.py \
  --scale 4 \
  --n_feats 64 \
  --n_resblocks 15 \
  --res_scale 1.0 \
  --pre_train experiments/pretrained_models/QBasicVSR.pth \
  --epochs 3 \
  --test_every 1 \
  --print_every 1 \
  --batch_size_update 2 \
  --batch_size_calib 8 \
  --num_data 100 \
  --patch_size 64 \
  --data_test REDS4 \
  --dir_data QBasicVSR/datasets \
  --quantize_a 6 \
  --quantize_w 6 \
  --quantizer minmax \
  --ema_beta 0.9 \
  --quantizer_w omse \
  --lr_w 1e-3 \
  --lr_a 1e-5 \
  --lr_measure_video 0.1 \
  --lr_measure_layer 0.1 \
  --w_sktloss 0.1 \
  --videowise \
  --layerwise \
  --bac \
  --img_percentile 10.0 \
  --layer_percentile 30.0 \
  --save basicvsr_x4/w6a6 \
  --seed 1 \
  --temporal_percentile 30 \
  --gamma_ 200 \
  --lambda_ 10 \
  --test