
# dataset settings
dataset_type = 'ImageNet'
dataset_data_prefix = 'data/imagenet_sketch/'
img_norm_cfg = dict(
    mean=[118.83, 120.105, 96.9], std=[49.725, 49.47, 48.96], to_rgb=True)
train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='RandomResizedCrop', size=224, backend='pillow'),
    dict(type='RandomFlip', flip_prob=0.5, direction='horizontal'),
    dict(type='AutoAugment', policies='ImageNetPolicy'),
    dict(type='Normalize', **img_norm_cfg),
    dict(type='ImageToTensor', keys=['img']),
    dict(type='ToTensor', keys=['gt_label', 'gt_logit']),
    dict(type='Collect', keys=['img', 'gt_label', 'gt_logit'])
]
test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='Resize', size=(256, -1), backend='pillow'),
    dict(type='CenterCrop', crop_size=224),
    dict(type='Normalize', **img_norm_cfg),
    dict(type='ImageToTensor', keys=['img']),
    dict(type='Collect', keys=['img'])
]
data = dict(
    samples_per_gpu=32,
    workers_per_gpu=2,
    sampler=dict(),
    train=dict(
        type=dataset_type,
        data_prefix=dataset_data_prefix,
        pipeline=train_pipeline),
    val=dict(
        type=dataset_type,
        data_prefix=dataset_data_prefix,
        pipeline=test_pipeline),
    test=dict(
        # replace `data/val` with `data/test` for standard test
        type=dataset_type,
        data_prefix=dataset_data_prefix,
        pipeline=test_pipeline))
evaluation = dict(interval=1, metric='accuracy')