_base_ = [
    '../_base_/models/resnet18.py', '../_base_/datasets/visda17test_bs32_pil_resize_autoaug.py',
    '../_base_/schedules/visda17_bs256_coslr.py', '../_base_/default_runtime.py'
]
model = dict(
    head=dict(
        num_classes=12,
        loss=dict(type='SoftCrossEntropyLoss'),
        topk=(1,)
    ))
data = dict(
    samples_per_gpu=256,
    train=dict(soft_file='work_dirs/r101_shot_visda17test.pkl')) # 256*1
runner = dict(max_epochs=10)
checkpoint_config = dict(interval=10)
log_config = dict(
    interval=50,
    hooks=[
        dict(type='TextLoggerHook'),
        dict(
            type='WandbLoggerHook',
            init_kwargs=dict(
                project='OTA_DEV',
                name='xent_phase1',
            )
        )
    ]
)
load_from='work_dirs/r18_moco2_visda17test.pth'