_base_ = [
    '../_base_/models/resnet18.py', '../_base_/datasets/officehome_C_bs32_pil_resize_autoaug.py',
    '../_base_/schedules/officehome_bs256_coslr.py', '../_base_/default_runtime.py'
]
model = dict(
    head=dict(
        num_classes=65,
        loss=dict(type='SoftCrossEntropyLoss'),
        topk=(1,)
    ))
data = dict(
    samples_per_gpu=256,
    train=dict(soft_file='work_dirs/r50tent_r18pretrain_xxx_officehome_rc_1gpu_b256_autoaug_xent_phase2/latest.pkl')) # 256*1
runner = dict(max_epochs=10)
checkpoint_config = dict(interval=10)
evaluation = dict(interval=1, metric='accuracy')
log_config = dict(
    interval=5,
    hooks=[
        dict(type='TextLoggerHook'),
        dict(
            type='WandbLoggerHook',
            init_kwargs=dict(
                project='OTA_DEV',
                name='xent_phase3',
            )
        )
    ]
)
load_from='work_dirs/r18_pretrain_officehome_r.pth'