# On-Target Adaptation

This repository is the official implementation of On-Target Adaptation. The code is developed based on [MMClassification Release V0.12.0](https://github.com/open-mmlab/mmclassification/releases/tag/v0.12.0).

Domain adaptation seeks to mitigate shift between training on the source domain and testing on the target domain. Most adaptation methods rely on the source data by joint optimization over source data and target data. Source-free methods replace the source data with a source model by ﬁne-tuning it on target. Either way, the majority of the parameter updates for the model representation and the classiﬁer are derived from the source, and not the target. However, target accuracy is the goal, and so we argue for optimizing as much as possible on the target data. We show signiﬁcant improvement by on-target representation learning, which learns the representation purely from target data while taking only the source predictions for supervision. In the long-tailed classiﬁcation setting, we show further improvement by on-target class distribution learning, which learns the (im)balance of classes from target data.

<!-- >📋  Optional: include a graphic explaining your approach/main result, bibtex entry, link to demos, blog posts and tutorials -->

## Installation
```
git clone https://github.com/xxx/OTA_DEV.git
cd OTA_DEV
```

Follow the instruction here: [mmcls installation](https://github.com/open-mmlab/mmclassification/blob/master/docs/install.md)

Download datasets in **OTA_DEV/data**.
```
OTA_DEV
├── data
│   ├── visda17
│   │   ├── train
│   │   ├── validation
│   │   ├── test
│   ├── imagenet_sketch
│   │   ├── n01440764
│   │   ├── n01443537
│   │   ├── ...
│   ├── office_home
│   │   ├── Art
│   │   ├── Clipart
│   │   ├── Product
│   │   ├── Real_World
│   ├── iNaturalist18
│   │   ├── iNaturalist18_val.txt
│   │   ├── train_val2018
│   ├── imagenet
│   │   ├── ImageNetLTtest.txt
│   │   ├── meta
│   │   ├── train
│   │   ├── val
```

Download checkpoints(student) and pikles(teacher) in **OTA_DEV/work_dirs**.


## Training

To train the model(s) in the paper, run this command:

```train
bash run.sh [config name]
```

<!-- >📋  Describe how to train the models, with example commands on how to train the models in your paper, including the full training procedure and appropriate hyperparameters. -->


## Pre-trained Models

You can download pretrained models here:

- [Checkpoints & soft labels](https://drive.google.com/drive/folders/1fqB1xfvVDh4kMZeAN2Y6SIn7lpaklDiw)

<!-- >📋  Give a link to where/how the pretrained models can be downloaded and how they were trained (if applicable).  Alternatively you can have an additional column in your results table with a link to the models. -->

## Results

Our model achieves the following performance on :

### [VisDA train → val](http://ai.bu.edu/visda-2017/)
<!-- ### [VisDA train → val](https://paperswithcode.com/sota/image-classification-on-imagenet) -->

```
# download and put r50_tent_visda17.pkl, r18_moco2_visda17.pth in OTA_DEV/work_dirs
bash run.sh r50tent_r18moco_xxx_visda17_1gpu_b256_autoaug

# download and put r101_shot_visda17.pkl, r18_moco2_visda17.pth in OTA_DEV/work_dirs
bash run.sh r101shot_r18moco_xxx_visda17_1gpu_b256_autoaug
```

| method    | plane | bcycl | bus  | car  | horse | knife | mcycl | person | plant | sktbrd | train | trunk | avg. | acc. |
|-----------|-------|-------|------|------|-------|-------|-------|--------|-------|--------|-------|-------|------|------|
| r50 TENT  | 58.9  | 40.1  | 50.2 | 23.6 | 22.6  | 25.3  | 29.8  | 24.8   | 22.9  | 30.2   | 45.1  | 20.1  | 32.8 | 31.4 |
| Ours      | 90.5  | 65.2  | 79.6 | 38.8 | 26.7  | 12.9  | 51.6  | 59.9   | 44.2  | 46.0   | 71.1  | 24.0  | 50.9 | 49.9 |
| r101 SHOT | 94.6  | 86.6  | 79.5 | 55.6 | 93.6  | 96.1  | 79.8  | 80.7   | 89.2  | 89.0   | 86.1  | 57.1  | 82.3 | 77.8 |
| Ours      | 96.0  | 89.5  | 84.3 | 67.2 | 95.9  | 94.2  | 91.0  | 81.5   | 93.8  | 89.9   | 89.1  | 58.2  | 85.9 | 82.8 |

### [VisDA train → test](http://ai.bu.edu/visda-2017/)
<!-- ### [VisDA train → val](https://paperswithcode.com/sota/image-classification-on-imagenet) -->

```
# download and put r50_tent_visda17test.pkl, r18_moco2_visda17test.pth in OTA_DEV/work_dirs
bash run.sh r50tent_r18moco_xxx_visda17test_1gpu_b256_autoaug

# download and put r101_shot_visda17test.pkl, r18_moco2_visda17test.pth in OTA_DEV/work_dirs
bash run.sh r101shot_r18moco_xxx_visda17test_1gpu_b256_autoaug
```

| method    | plane | bcycl | bus  | car  | horse | knife | mcycl | person | plant | sktbrd | train | trunk | avg. | acc. |
|-----------|-------|-------|------|------|-------|-------|-------|--------|-------|--------|-------|-------|------|------|
| r50 TENT  | 51.5  | 32.1  | 34.8 | 60.5 | 24.6  | 24.0  | 28.3  | 26.4   | 26.1  | 35.8   | 37.8  | 28.2  | 34.2 | 34.3 |
| Ours      | 83.2  | 47.6  | 57.8 | 91.6 | 19.5  | 12.8  | 52.2  | 59.0   | 28.3  | 41.9   | 63.9  | 33.9  | 49.3 | 51.2 |
| r101 SHOT | 93.1  | 89.5  | 90.6 | 92.6 | 91.7  | 97.0  | 71.8  | 81.4   | 95.7  | 89.9   | 89.4  | 89.2  | 89.3 | 88.4 |
| Ours      | 94.9  | 88.8  | 94.0 | 95.9 | 93.8  | 95.2  | 86.6  | 83.2   | 96.2  | 86.0   | 93.2  | 92.4  | 91.7 | 91.6 |

### [ImageNet → Sketch](https://paperswithcode.com/dataset/imagenet-sketch)

```
# download and put r50_tent_imagenet_sketch.pkl, resnet18_imagenet.pth in OTA_DEV/work_dirs
bash run.sh r50tent_r18pretrain_xxx_sketch_1gpu_b256_autoaug
```

| student            | teacher         | interaction    | tent acc.          |    ours acc.       |
| ------------------ |---------------- | -------------- | ------------------ | ------------------ |
|     r18 imagenet   |      r50 TENT   |    xxx         | 35.6               | 37.5               |

### [Office-Home](https://paperswithcode.com/dataset/office-home)

```
# download and put r50_tent_officehome_ac.pkl, r18_pretrain_officehome_a.pth ... in OTA_DEV/work_dirs
bash run.sh r50tent_r18pretrain_xxx_officehome_ac_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_ap_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_ar_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_ca_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_cp_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_cr_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_pa_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_pc_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_pr_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_ra_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_rc_1gpu_b256_autoaug
bash run.sh r50tent_r18pretrain_xxx_officehome_rp_1gpu_b256_autoaug
```

| student            | teacher         | interaction    | tent acc.          |    ours acc.       |
| ------------------ |---------------- | -------------- | ------------------ | ------------------ |
|     r18 imagenet   |      r50 TENT   |    xxx         | 53.8               | 56.8               |

### [iNaturalist18](https://github.com/visipedia/inat_comp/tree/master/2018)

```
# download and put iNaturalist18_resnet50_uniform_e90.pkl, iNaturalist18_resnet50_uniform_e90.pth in OTA_DEV/work_dirs
bash run.sh LT_uni90_resnet50_xkx_inat18_1gpu_b512_lws_cas
```

| method    | many | medium | few  | acc. |
|-----------|------|--------|------|------|
| r50       | 72.2 | 63     | 57.2 | 61.7 |
| LWS       | 65   | 66.3   | 65.5 | 65.9 |
| Ours      | 64.2 | 66.3   | 65.9 | 65.9 |

### [ImageNet-LT](https://paperswithcode.com/dataset/imagenet-lt)

```
# download and put ImageNetLT_resnet50_uniform_e90.pkl, ImageNetLT_resnet50_uniform_e90.pth in OTA_DEV/work_dirs
bash run.sh LT_uni90_resnet50_xkx_imagenetlt_1gpu_b512_lws_cas
```

| method    | many | medium | few  | acc. |
|-----------|------|--------|------|------|
| r50       | 64   | 33.8   | 5.8  | 41.6 |
| LWS       | 57.1 | 45.2   | 29.3 | 47.7 |
| Ours      | 55.7 | 46     | 28.6 | 47.4 |

<!-- >📋  Include a table of results from your paper, and link back to the leaderboard for clarity and context. If your main result is a figure, include that figure and link to the command or notebook to reproduce it.  -->

All processes are logged by [Weight & Biases](https://wandb.ai/site).

All feature distributions, as shown in paper Figure 1, are displayed in **OTA_DEV/feat_dist**.
<!-- ## Contributing

>📋  Pick a licence and describe how to contribute to your code repository.  -->

## Acknowledgement
* [mmclassification](https://github.com/open-mmlab/mmclassification)
* [vissl](https://github.com/facebookresearch/vissl)
* [classifier-balancing](https://github.com/facebookresearch/classifier-balancing)
