import argparse
from transformers import BertTokenizer, BertModel, AutoTokenizer
from tqdm import tqdm
import numpy as np
import torch.nn.functional as F
import random
import os
from utils.config import MODEL_DIR, DATA_DIR
import json
from transformers import LlamaTokenizer, AutoModelForCausalLM

def generate_mapping(size=30000, dimension=300):
    return [random.randint(0, dimension-1) for _ in range(size)]

def main(args):
    length = len(LlamaTokenizer.from_pretrained(os.path.join(MODEL_DIR, args.model_name)))
    mapping = generate_mapping(length, args.dimension)
    
    with open(os.path.join(DATA_DIR, f"mapping/mapping_{args.model_name}.json"), 'w') as f:
        json.dump(mapping, f, indent=4)

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='Generate a mapping with given size and dimension.')
    parser.add_argument('--model_name', type=str, default='llama', help='Name of the pretrained model')
    parser.add_argument('--size', type=int, default=50272, help='Size of the mapping')
    parser.add_argument('--dimension', type=int, default=300, help='Dimension of the mapping')
    args = parser.parse_args()
    
    main(args)
