#!/bin/bash

# RAVDESS数据集采样示例脚本

# 设置数据集路径（请根据实际情况修改）
DATASET_PATH="/mnt/sdd/share/datasets/speech/emotional_datasets/RAVDESS"

# 设置保存路径
SAVE_PATH="/mnt/sdd/share/datasets/speech/emotional_datasets/RAVDESS/selected"

# 示例1: 采样happy情绪的音频文件
echo "采样happy情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion happy \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo ""

# 示例2: 采样sad情绪的音频文件
echo "采样sad情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion sad \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo ""

# 示例3: 采样angry情绪的音频文件
echo "采样angry情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion angry \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo ""

# 示例4: 采样fearful情绪的音频文件
echo "采样fearful情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion fearful \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo ""

# 示例5: 采样disgust情绪的音频文件
echo "采样disgust情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion disgust \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo ""

# 示例6: 采样surprised情绪的音频文件
echo "采样surprised情绪的音频文件..."
python sample.py \
    --dataset_path "$DATASET_PATH" \
    --emotion surprised \
    --num_samples 1000 \
    --save_path "$SAVE_PATH" \
    --seed 42

echo "采样完成！"
echo "所有采样结果保存在: $SAVE_PATH" 