#!/bin/bash

# Define datasets and corresponding task types using an associative array
declare -A dataset_tasks
dataset_tasks=(
    ["topology_classification"]="topology_classification"
)

layouts=("kamada_kawai")
gnn_models=("gat" "gin" "gps" "gcn")
seeds=(0)
gnn_num_layers=2

# Fixed hyperparameters
batch_size=128
epochs=100
patience=50
dropout_rate=0.5
gnn_hidden_dim=128
image_size=224
vision_lr=1e-5
vision_weight_decay=1e-4
classifier_lr=1e-3
gnn_lr=1e-3

# Iterate over datasets and corresponding task types
for dataset in "${!dataset_tasks[@]}"; do
  task_type="${dataset_tasks[$dataset]}"
  
  for layout in "${layouts[@]}"; do
    for seed in "${seeds[@]}"; do
      
      echo "===================="
      echo "Dataset: ${dataset}"
      echo "Task Type: ${task_type}"
      echo "Layout: ${layout}"
      echo "Seed: ${seed}"
      echo "Patience: ${patience}"
      echo "===================="

      for gnn_model in "${gnn_models[@]}"; do
        echo "Running GNN Model: ${gnn_model}"
        CUDA_VISIBLE_DEVICES=1 python ./src/baseline.py \
          --model_type "gnn" \
          --gnn_model_name "${gnn_model}" \
          --dataset "${dataset}" \
          --layout "${layout}" \
          --seed "${seed}" \
          --batch_size "${batch_size}" \
          --epoch "${epochs}" \
          --patience  "30" \
          --dropout_rate "${dropout_rate}" \
          --gnn_num_layers "${gnn_num_layers}" \
          --gnn_hidden_dim "${gnn_hidden_dim}" \
          --gnn_lr "${gnn_lr}" \
          --task_type "${task_type}"
        sleep 10
      done
    done
  done
done
