#!/bin/bash

declare -A dataset_tasks
dataset_tasks=(
    ["topology_classification"]="topology_classification"
)

layouts=("forceatlas2" "kamada_kawai")
vision_models=("vit" "resnet" "convnext" "swin" )
gnn_models=("gps" "gcn" "gat" "gin") 
seeds=(0 1 2 3 4)

batch_size=128
epochs=100
patience=5
dropout_rate=0.5
gnn_num_layers=2
gnn_hidden_dim=128
image_size=224
vision_lr=1e-5
vision_weight_decay=1e-4
classifier_lr=1e-3

for dataset in "${!dataset_tasks[@]}"; do
  task_type="${dataset_tasks[$dataset]}"
  
  for layout in "${layouts[@]}"; do
    for seed in "${seeds[@]}"; do
      
      echo "===================="
      echo "Dataset: ${dataset}"
      echo "Task Type: ${task_type}"
      echo "Layout: ${layout}"
      echo "Seed: ${seed}"
      echo "Patience: ${patience}"
      echo "===================="
   
      for vision_model in "${vision_models[@]}"; do
        echo "Running Vision Model: ${vision_model}"
        CUDA_VISIBLE_DEVICES=1 python baseline.py \
          --model_type "vision" \
          --vision_model_name "${vision_model}" \
          --dataset "${dataset}" \
          --layout "${layout}" \
          --seed "${seed}" \
          --batch_size "${batch_size}" \
          --epoch "${epochs}" \
          --patience "${patience}" \
          --dropout_rate "${dropout_rate}" \
          --image_size "${image_size}" \
          --vision_lr "${vision_lr}" \
          --vision_weight_decay "${vision_weight_decay}" \
          --classifier_lr "${classifier_lr}" \
          --gnn_num_layers "${gnn_num_layers}" \
          --task_type "${task_type}"
        
        sleep 10
      done

      for gnn_model in "${gnn_models[@]}"; do
        echo "Running GNN Model: ${gnn_model}"
        CUDA_VISIBLE_DEVICES=7 python baseline.py \
          --model_type "gnn" \
          --gnn_model_name "${gnn_model}" \
          --dataset "${dataset}" \
          --layout "${layout}" \
          --seed "${seed}" \
          --batch_size "${batch_size}" \
          --epoch "${epochs}" \
          --patience  "30" \
          --dropout_rate "${dropout_rate}" \
          --gnn_num_layers "${gnn_num_layers}" \
          --gnn_hidden_dim "${gnn_hidden_dim}" \
          --task_type "${task_type}"
        
        sleep 10
      done
      
    done
  done
done