# Blind Submission Code

This code package provides an example implementation from our paper submission. Below you will find instructions for setting up the environment and running the experiments.

## Environment Setup

We recommend creating a conda environment to run our code:

```bash
# Create a new conda environment named GraphAbstract with Python 3.10
conda create -n GraphAbstract python=3.10 "numpy<2.0"

# Activate the environment
conda activate GraphAbstract

# Install PyTorch with CUDA support
conda install pytorch==2.0.1 torchvision==0.15.2 torchaudio==2.0.2 pytorch-cuda=11.7 -c pytorch -c nvidia

# Install PyTorch Geometric and its dependencies
pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.0.1+cu117.html
pip install torch_geometric

# Install other required packages
pip install scikit-learn pandas
conda install transformers
pip install seaborn matplotlib
pip install pynauty
```

## Running the Experiments

To reproduce the main results from our paper:

```bash
# Run GNN experiments with one-hot degree features
bash scripts/baseline-g.sh

# Run vision model experiments with different layouts
bash scripts/baseline-v.sh
```