## Installation

1. Set up conda / pip.
2. Install Lexa envs

3. Install MEGA envs

4. Set up DreamerV2 local pip installation.
```
# make sure you're in the dreamerv2 folder
pip install -e .
```

## Running the script

1. Setting up the conda env and RL environments.
```
conda activate lexa-bench
# if you want to run LEXA environments
export PYTHONPATH=<path to lexa-bench folder>
# if you want to run MEGA environments
export PYTHONPATH=<path to mrl folder>
# and you cannot have both at once
```

2. Running the agent.
Pass in the config setting(s) you want from the `configs.yaml`. If there are multiple configs, we will override previous configs with later ones, like if you want to add debug mode to your environment.

To override specific config keys, pass them in with `--key value`.

`python examples/run_goal_cond.py --configs <setting 1> <setting 2> ... --foo bar`

- Examples:
  - Normal scenario
    - `python examples/run_goal_cond.py --configs mega_fetchpnp_proprio`
  - Debug scenario
    - `python examples/run_goal_cond.py --configs mega_fetchpnp_proprio debug` 
  - Override scenario 
    - `python examples/run_goal_cond.py --configs mega_fetchpnp_proprio --seed 123`

Now start up tensorboard instance in another window, and go to the IP address.
```
cd ~/logdir
tensorboard . 
```
