#!/usr/bin/zsh
echo "All Goals"
python3 common/plot.py --indir ~/logdir/expt_anthard/ --outdir "~/plotdir/anthard/goal_all" --xaxis step --yaxis "max_eval_metric_success/goal_all" --bins 5e4 --methods   ^mppi2$   ^mega$  ^p2e$ ^skewfit$ --add none --ylabel success --xlabel steps --size 7 7 --xlim 0 1000000

for i in {0..7}
do
echo "Goal: $i"
GOAL=$i; 
python3 common/plot.py --indir ~/logdir/expt_anthard/ --outdir "~/plotdir/anthard/goal_${GOAL}" --xaxis step --yaxis "mean_eval_metric_success/goal_${GOAL}" --bins 5e4 --methods   ^mppi2$   ^mega$ ^p2e$ ^skewfit$ --add none --ylabel success --xlabel steps --size 7 7 --xlim 0 1000000
done
