import argparse
import tensorflow as tf
from tensorflow.python.summary.summary_iterator import summary_iterator
import imageio
import cv2

parser = argparse.ArgumentParser(description='Create a gif from tensorboard file images')
parser.add_argument(
  'filename',
  type=str,
  help='Path to tensorboard file'
)
parser.add_argument(
    '--method',
    type=str,
)
parser.add_argument(
    '--output',
    default="./out.mp4",
    type=str,
    help='File to store the final result'
)
parser.add_argument(
    '--start',
    type=int,
    help='First image in the gif (corresponds to tensorboard step)'
)
parser.add_argument(
    '--stop',
    type=int,
    help='Last image in the gif (corresponds to tensorboard step)'
)

args = parser.parse_args()
all_imgs = []
color = (255, 0, 0)
thickness = 1
for e in summary_iterator(args.filename):
  step = e.step
  if step < args.start:
    continue
  if step > args.stop:
    break

  for v in e.summary.value:
    if v.tag == 'state_occupancy':
      step = e.step
      img_str = v.image.encoded_image_string
      height = v.image.height
      width = v.image.width
      img = tf.squeeze(tf.io.decode_image(img_str, channels=3))
      img = img.numpy()
      cv2.putText(
            img,
            f"{step}",
            (16, 32),
            cv2.FONT_HERSHEY_SIMPLEX,
            1.5,
            color,
            thickness,
            cv2.LINE_AA,
      )
      cv2.putText(
            img,
            f"{args.method}",
            (350, 32),
            cv2.FONT_HERSHEY_SIMPLEX,
            1.5,
            color,
            thickness,
            cv2.LINE_AA,
      )
      all_imgs.append(img)
# make gif
print("writing", len(all_imgs))
imageio.mimwrite(args.output, all_imgs)


