#!/bin/bash
#SBATCH --qos=viz
#SBATCH --partition=viz
#SBATCH --cores=4
#SBATCH -o slurm-tb.out

PORT_MAP=/tmp/tensorboard_port_map

TB_PORT=$(cat $PORT_MAP | grep "$SLURM_JOBID," | cut -d',' -f2)
IP_ADDRESS=$(hostname -I | cut -d' ' -f1)

TB_FOLDER=$1

echo "Go to http://$IP_ADDRESS:$TB_PORT"

ulimit -n 50000

timeout 7.5h tensorboard --bind_all --logdir $TB_FOLDER --port $TB_PORT

exit 3
