import gym
import frontier_maze
import dreamerv2.api as dv2
import tensorflow as tf
from common import Config

seed=0
config = dv2.defaults.update({
    'logdir': f'~/logdir/testdv1_p2e_3models8bs_0extr_seed{seed}',
    'seed': seed,
    # plan2explore args
    'expl_behavior': 'Plan2Explore',
    'expl_extr_scale': 0.0,
    'disag_models': 3,
    'dataset': {'batch': 8, 'length': 50}

})
proprio_defaults = Config(dv2.configs.pop('dmc_proprio'))
config = config.update(proprio_defaults)
config.pop("task")
config.pop("log_keys_video")
config = config.parse_flags()

env = gym.make('normalizeddistractormaze2d-v1')
message = 'No GPU found. To actually train on CPU remove this assert.'
assert tf.config.experimental.list_physical_devices('GPU'), message
# env = gym_minigrid.wrappers.RGBImgPartialObsWrapper(env)
dv2.train(env, config)
