# Federated Conforaml Fairness

## High Leevel Explanation of FedCF using FLWR

Although FedCF is unlike neural-network training, where we apply FedAvg to the entire network every round,
we have several different stages in FedCF. Thus, to fit our procedure to flwr, we implement a state machine within
our custom flwr strategy. In the first stage, we compute the minimum '''q_hat''' value, i.e., a Federated conformal predictor
as described in FedCP, to satisfy coverage. Then we compute the population stats in the second stage. Lastly, we go through
rounds in the reworked fairless conformal fairness optimization framework.

In each stage, the server sends the necessary information over via the configure fit. Importantly, the server strategy
indicates to the client what stage the server is in via the configure fit. Then, based on the stage it is in, the client
computes the necessary components/coverage values/probabilities for each stage.

## Environment export from conda

```bash
conda env export | grep -v "name" | grep -v "prefix" > environment.yml
```

## Directory Structure

- `base_fed_model` contains the code for training the base fed model

- `datasets` contains raw data for Pokec-{n, z}. For ACS datasets, they are downloaded through the code. The Fitzpatrick images can be requested using this [Google Form](https://forms.gle/4fS35Kg8x9pkG2Bn9) from the original Fitzpatrick dataset authors.

- `scripts` contains SLURM batch scripts used to run the experiments

- `analysis` contains notebooks for generating figures

- `configs` contains configs for the different experiments

The remaining Python files are for the various datamodules, utilities and FedCF logic. FedCF can be executed from the SLURM scripts or executing the `run_fed_cf.py` script.
