#!/bin/bash



module load cuda/12.3.0
PROJECTDIR="$HOME/federated_dir/federated-conformal-fairness"
CONDAENV=myenv



best_param_path="${PROJECTDIR}/configs/base_fitzpatrick_config.yaml"

echo Job started at `date` on `hostname`
# CONDA SETUP
source ~/.bashrc
conda deactivate
echo conda ${CONDAENV}
conda activate ${CONDAENV}
export PYTHONPATH=$PROJECTDIR
cd $PYTHONPATH

python -c "import torch, sys, flwr; print(torch.cuda.is_available(), torch.version.cuda, sys.executable, flwr.__file__)"

# === Extract values from YAML config ===
eval $(python - <<EOF
import yaml
config_path = "${best_param_path}"
with open(config_path, 'r') as f:
    cfg = yaml.safe_load(f)

# Print in export format for bash
print(f'export EPOCHS={cfg.get("epochs", 100)}')
print(f'export JOB_ID="{cfg.get("job_id", "default_job")}"')

ds_name = cfg.get("dataset", {}).get("name")
print(f'export DATASET={ds_name}')
# Dataset splits
train_frac = cfg.get("dataset_split_fractions", {}).get("train", 0.7)
valid_frac = cfg.get("dataset_split_fractions", {}).get("valid", 0.1)
print(f'export TRAIN_FRAC={train_frac}')
print(f'export VAL_FRAC={valid_frac}')
EOF
)
config_output_dir="$PROJECTDIR/outputs/${DATASET}/split/${TRAIN_FRAC}_${VAL_FRAC}"
ds_folder="/fs/ess/PAS2030/fedcf/datasets/finalfitz17k"


python base-fed-model/main.py --config_path=${best_param_path} --logging_config.use_wandb False --output_dir ${config_output_dir} --dataset_dir ${ds_folder} --dataset.csv_file ${PROJECTDIR}/fitzpatrick17k.csv --job_id ${JOB_ID} --epochs 100 --base_model_config.architecture resnet18 
