#!/bin/bash

PROJECTDIR="$HOME/federated-conformal-fairness"
CONDAENV=fedcf
TRAIN_FRAC=0.3
VAL_FRAC=0.2
ALPHA=0.1
closeness_measure=0.1

base_output_dir="$PROJECTDIR/outputs"
ds_folder="$PROJECTDIR/datasets"

DATASET="cail"

for sens_attr_prefix in "_gender" "_region" ""; do
    sens_attr="${sens_attr_prefix//_}"
    if [ -z "${sens_attr}" ]; then
        sens_attr="region_gender"
    fi
        for sketch_method in tdigest ddsketch; do # mean 
            job_id="best_${DATASET}_split_${TRAIN_FRAC}_${VAL_FRAC}${sens_attr_prefix}"
            config_output_dir="$base_output_dir/${DATASET}/split/${TRAIN_FRAC}_${VAL_FRAC}${sens_attr_prefix}"

            for METRIC in "Demographic_Parity"
            do
                for METHOD in "raps"
                do
                    config_path="$PROJECTDIR/configs/fair_fedcf_fairlex_config.yaml"
                    cd ${PROJECTDIR}
sbatch <<EOT
#!/bin/bash
#SBATCH --account general
#SBATCH --partition=cpu_batch
#SBATCH --nodes=1
#SBATCH --ntasks-per-node=1
#SBATCH --cpus-per-task=4
#SBATCH --time=1-00:00:00
#SBATCH -J c_${DATASET}_${TRAIN_FRAC}_${VAL_FRAC}${sens_attr_prefix}_${METHOD}
#SBATCH -e logs/fedcf/${DATASET}/${TRAIN_FRAC}_${VAL_FRAC}${sens_attr_prefix}_${sketch_method}/${METRIC}/closeness_${closeness_measure}_%A.err
#SBATCH -o logs/fedcf/${DATASET}/${TRAIN_FRAC}_${VAL_FRAC}${sens_attr_prefix}_${sketch_method}/${METRIC}/closeness_${closeness_measure}_%A.out

echo Job started at `date` on `hostname`
# CONDA SETUP
source ~/.bashrc
conda deactivate
conda activate ${CONDAENV}

export DGLBACKEND=pytorch

export TOKENIZERS_PARALLELISM=false

cd ${PROJECTDIR}
python run_fed_cf.py --config_path=${config_path} \
    --logging_config.use_wandb False \
    --dataset.name=${DATASET} \
    --dataset.sens_attrs '["${sens_attr}"]' \
    --fairness_metric=${METRIC} \
    --conformal_method=${METHOD} \
    --job_id=c_${DATASET}_${TRAIN_FRAC}_${VAL_FRAC}_${METHOD}_${sketch_method} \
    --dataset_split_fractions.train ${TRAIN_FRAC} \
    --dataset_split_fractions.valid ${VAL_FRAC} \
    --alpha $ALPHA \
    --base_job_id=${job_id} \
    --dataset.name=${DATASET} \
    --output_dir=${config_output_dir} \
    --dataset_dir ${ds_folder} \
    --closeness_measure ${closeness_measure} \
    --quantile_method ${sketch_method} \
    --resource_config.cpus 8 \
    --resource_config.gpus 0 \

EOT
            done
        done
    done
done
