from pycocotools.coco import COCO
import json
import os

# 1) load the COCO annotation file
coco = COCO("PATH/BackdoorObjectDetection/data/coco/annotations/instances_train2017.json") # YOU MUST SET THIS

# 2) get all category IDs (these are the original COCO IDs 1–90, with gaps)
cat_ids = coco.getCatIds()      # e.g. [1, 2, 3, 4, 6, 8, …, 90]

# 3) sort them to guarantee the same order every run
cat_ids = sorted(cat_ids)       # still [1, 2, 3, 4, 6, 8, …, 90]

# 4) build the mapping to indices 0…79
cat2idx = {cat_id: idx for idx, cat_id in enumerate(cat_ids)}

# save the mapping to a file called `coco_id_mapping.json`
path = os.path.join(os.path.dirname(__file__), "mappings", "coco_id_mapping.json")

with open(path, "w") as f:
    json.dump(cat2idx, f, indent=4)