import torch
import pickle
import numpy as np
from PIL import Image
import pickle
from datasets.BaseDataset import BaseDataset


class HAM10000(BaseDataset):
    def __init__(self, dataframe, path_to_pickles, sens_name, sens_classes, transform, no_return_idx = False):
        super(HAM10000, self).__init__(dataframe, path_to_pickles, sens_name, sens_classes, transform)
        
        self.no_return_idx = no_return_idx
        
        with open(path_to_pickles, 'rb') as f: 
            self.tol_images = pickle.load(f)
            
        if self.sens_name == 'Sex':
            self.A = np.asarray(self.dataframe['Sex'].values != 'M').astype('float')
        elif self.sens_name == 'Age':
            self.A = np.asarray(self.dataframe['Age_binary'].values.astype('int') == 0).astype('float')
        elif self.sens_name == 'Race':
            raise ValueError('There is no Race attribute in HAM10000 dataset.')
        
        self.Y = (np.asarray(self.dataframe['binaryLabel'].values) > 0).astype('float')
        self.AY_proportion = None
        

    def __getitem__(self, idx):
        item = self.dataframe.iloc[idx]

        img = Image.fromarray(self.tol_images[idx])

        img = self.transform(img)

        label = torch.FloatTensor([int(item['binaryLabel'])])
        
        if self.sens_name == 'Sex':
            if item['Sex'] == 'M':
                sensitive = 0
            else:
                sensitive = 1
        elif self.sens_name == 'Age':
            if self.sens_classes == 2:
                sensitive = int(item['Age_binary'])
            elif self.sens_classes == 5:
                sensitive = int(item['Age_multi'])
            elif self.sens_classes == 4:
                sensitive = int(item['Age_multi4'])
                               
        if self.no_return_idx:
            return img, label, sensitive
        else:
            return idx, img, label, sensitive