# Welcome to the tutorial of the biomedical fairness benchmark! 

## Quick Start
- [Installation](quickstart.md#installation)
- [Dataset Download](quickstart.md#dataset-download)
- [Running Experiments](quickstart.md#usage)
- [Analyze Results](quickstart.md#analysis)

## Experiment Customization
- [Customize Dataset](customization.md#customize-dataset)
- [Customize Network Architectures](customization.md#customize-network-architectures)
- [Customize Debiasing Algorithms](customization.md#customize-debiasing-algorithms)
- [Customize Evaluation Metrics](customization.md#customize-evaluation-metrics)

## Code Structure
- `configs`: Configuration for datasets and [Weight and Bias](https://wandb.ai/).
- `datasets`: Dataset class for loading data.
- `docs`: Documentations.
- `flatness`: Code for calculating flatness.
- `loss_surface`: Code for loss surface visualization.
- `models`: Implementation of debiasing algorithms.
- `preprocessing`: Data preprocessing scripts.
- `utils`: Some useful functions.
- `main.py`: Main entry file.
- `cal_flatness.py`: Entry file for calculating flatness.

## References
- [Datasets](reference.md#datasets)
- [Debiasing Methods](reference.md#debiasing-methods)