import torch
import pickle
import numpy as np
from PIL import Image
import pickle
from datasets.BaseDataset import BaseDataset


class MIMIC_CXR(BaseDataset):
    def __init__(self, dataframe, PATH_TO_IMAGES, sens_name, sens_classes, transform, no_return_idx = False):
        super(MIMIC_CXR, self).__init__(dataframe, PATH_TO_IMAGES, sens_name, sens_classes, transform)
        
        self.no_return_idx = no_return_idx
        
        with open(PATH_TO_IMAGES, 'rb') as f: 
            self.tol_images = pickle.load(f)
            
        if self.sens_name == 'Sex':
            self.A = np.asarray(self.dataframe['Sex'].values != 'M').astype('float')
        elif self.sens_name == 'Age':
            self.A = np.asarray(self.dataframe['Age_binary'].values.astype('int') == 0).astype('float')
        elif self.sens_name == 'Race':
            self.A = np.asarray(self.dataframe['Race'].values != 'White').astype('float')
        
        self.Y = (np.asarray(self.dataframe['No Finding'].values) > 0).astype('float')
        self.AY_proportion = None

        self.PRED_LABEL = [
            'No Finding',
            'Enlarged Cardiomediastinum',
            'Cardiomegaly',
            'Lung Opacity',
            'Lung Lesion',
            'Edema',
            'Consolidation',
            'Pneumonia',
            'Atelectasis',
            'Pneumothorax',
            'Pleural Effusion',
            'Pleural Other',
            'Fracture',
            'Support Devices']

    def __getitem__(self, idx):
        item = self.dataframe.iloc[idx]
        
        img = Image.fromarray(self.tol_images[idx]).convert('RGB')

        img = self.transform(img)

        # label = np.zeros(len(self.PRED_LABEL), dtype=int)
        label = torch.FloatTensor(np.zeros(len(self.PRED_LABEL), dtype=float))
        for i in range(0, len(self.PRED_LABEL)):
            if (self.dataframe[self.PRED_LABEL[i].strip()].iloc[idx].astype('float') > 0):
                label[i] = self.dataframe[self.PRED_LABEL[i].strip()].iloc[idx].astype('float')

        if self.sens_name == 'Sex':
            if item['Sex'] == 'M':
                sensitive = 0
            else:
                sensitive = 1
        elif self.sens_name == 'Age':
            if self.sens_classes == 2:
                sensitive = int(item['Age_binary'])
            else:
                sensitive = int(item['Age_multi'])
        elif self.sens_name == 'Race':
            if item['Race'] == 'White':
                sensitive = 0
            else:
                sensitive = 1
                
        if self.no_return_idx:
            return img, label, sensitive
        else:
            return idx, img, label, sensitive