from .imagenet import VGG as IMAGENET_VGG
from .imagenet import AlexNet as IMAGENET_AlexNet
from .imagenet import ConvNeXt as IMAGENET_ConvNeXt
from .imagenet import DenseNet as IMAGENET_DenseNet
from .imagenet import EfficientNet as IMAGENET_EfficientNet
from .imagenet import GoogLeNet as IMAGENET_GoogLeNet
from .imagenet import Inception as IMAGENET_Inception
from .imagenet import MNASNet as IMAGENET_MNASNet
from .imagenet import MobileNet as IMAGENET_MobileNet
from .imagenet import RegNet as IMAGENET_RegNet
from .imagenet import ResNet as IMAGENET_ResNet
from .imagenet import ResNext as IMAGENET_ResNext
from .imagenet import ShuffleNet as IMAGENET_ShuffleNet
from .imagenet import VisionTransformer as IMAGENET_VisionTransformer
from .imagenet import WideResNet as IMAGENET_WideResNet
from .imagenet import MLPMixer as IMAGENET_MLPMixer

# from .cifar10 import VGG as CIFAR10_VGG
# from .cifar10 import ResNet as CIFAR10_ResNet
# from .cifar10 import PreResNet as CIFAR10_PreResNet
# from .cifar10 import ResNext as CIFAR10_ResNext
# from .cifar10 import SEResNet as CIFAR10_SEResNet
# from .cifar10 import SEPreResNet as CIFAR10_SEPreResNet
# from .cifar10 import DIAResNet as CIFAR10_DIAResNet
# from .cifar10 import DIAPreResNet as CIFAR10_DIAPreResNet
# from .cifar10 import PyramidNet as CIFAR10_PyramidNet
# from .cifar10 import DenseNet as CIFAR10_DenseNet
# from .cifar10 import WideResNet as CIFAR10_WideResNet
# from .cifar10 import WideResNet1b as CIFAR10_WideResNet1b
# from .cifar10 import WideResNet32b as CIFAR10_WideResNet32b
# from .cifar10 import XDenseNet as CIFAR10_XDenseNet
# from .cifar10 import NIN as CIFAR10_NIN
# from .cifar10 import RoR3 as CIFAR10_RoR3
# from .cifar10 import RiR as CIFAR10_RiR
# from .cifar10 import ShakeShakeResNet as CIFAR10_ShakeShakeResNet

from .nlp.glue import Roberta as SST2_Roberta
from .nlp.yahoo import ZeroShotBartYahoo
from .nlp.emotion import DistilBert as Emotion_DistilBert
from .nlp.amazon import BertBase as Amazon_BertBase

ALL_IMAGENET_NETWORKS = [
    IMAGENET_VGG,
    IMAGENET_ResNet,
    IMAGENET_AlexNet,
    IMAGENET_DenseNet,
    IMAGENET_Inception,
    IMAGENET_GoogLeNet,
    IMAGENET_ShuffleNet,
    IMAGENET_MobileNet,
    IMAGENET_ResNext,
    IMAGENET_WideResNet,
    IMAGENET_MNASNet,
    IMAGENET_EfficientNet,
    IMAGENET_RegNet,
    IMAGENET_VisionTransformer,
    IMAGENET_ConvNeXt,
    IMAGENET_MLPMixer,
]

ALL_CIFAR10_NETWORKS = [
    # # CIFAR10_VGG,
    # CIFAR10_ResNet,
    # CIFAR10_PreResNet,
    # CIFAR10_ResNext,
    # CIFAR10_SEResNet,
    # CIFAR10_SEPreResNet,
    # CIFAR10_DIAResNet,
    # CIFAR10_DIAPreResNet,
    # CIFAR10_PyramidNet,
    # CIFAR10_DenseNet,
    # CIFAR10_WideResNet,
    # # CIFAR10_WideResNet1b,
    # # CIFAR10_WideResNet32b,
    # CIFAR10_XDenseNet,
    # # CIFAR10_NIN,
    # CIFAR10_RoR3,
    # # CIFAR10_RiR,
    # CIFAR10_ShakeShakeResNet,
]

ALL_GLUE_NETWORKS = [
    SST2_Roberta,
]

ALL_YAHOO_NETWORKS = [
    ZeroShotBartYahoo,
]

ALL_EMOTION_NETWORKS = [
    Emotion_DistilBert,
]

ALL_AMAZON_NETWORKS = [
    Amazon_BertBase,
]

ALL_NETWORKS = (ALL_IMAGENET_NETWORKS + ALL_CIFAR10_NETWORKS +
ALL_GLUE_NETWORKS + ALL_YAHOO_NETWORKS + ALL_EMOTION_NETWORKS +
ALL_AMAZON_NETWORKS)
