import tempfile

import numpy as np

from .results import cluster_marginals, cluster_max
import pytest

@pytest.mark.parametrize('plot_cluster_id', [False, True])
def test_plot_frac_pos_vs_scores(plot_cluster_id):
    rs = np.random.RandomState(0)
    n = 10
    X = rs.uniform(size=(n, 3))
    y_labels = rs.randint(2, size=n)
    y_scores = rs.uniform(size=n)

    dir = tempfile.TemporaryDirectory()
    dirpath = dir.name

    cluster_max(X, y_labels, y_scores, name='test', out_dir=dirpath, min_cluster_size=1,
    plot_cluster_id=plot_cluster_id)
    cluster_marginals(X, y_labels, y_scores, name='test_marginal', out_dir=dirpath, min_cluster_size=1,
    plot_cluster_id=plot_cluster_id)
