# ICLR2023 – Beyond calibration: estimating the grouping loss of modern neural networks


## Install
```
conda install --file requirements.txt
```


## Structure
The most important files are:
* `calibration/xp_nn_calibration/test_figures.py` and `grouping/xp_grouping/test_figures.py`: code generating the figures present in the paper. Every experiment is written as a test function that can be run with pytest.

* `calibration/xp_nn_calibration/main.py`: the main partitioning algorithm is implemented in the `cluster_evaluate` function. It partition the feature space in each level set, and return the region scores as well as the counts and the averages confidence scores of the bin.

Other files are:
* `calibration/xp_nn_calibration/networks/`: code related to vision and NLP networks. All networks inherit the BaseNet class in `calibration/xp_nn_calibration/networks/base.py` which implements functions load the networks, forwards samples, extract transformed samples in the high level feature space, confidence scores...
* `_utils.py`, `_plot.py`, `_linalg.py` are implementing helper functions.
* All `test_*.py` except `test_figures.py` are implementing unit tests to test the functions of the repository.
