from collections import UserList
from dataclasses import dataclass


@dataclass
class SubjectPromptSet:
    live_prompts: list[str]
    object_prompts: list[str]

    def __repr__(self) -> str:
        # If the lists are too long, truncate the output.
        if len(self.live_prompts) > 10 or len(self.object_prompts) > 10:
            return "\n".join(
                [
                    "SubjectPromptSet(",
                    f"  live_prompts ({len(self.live_prompts)}):",
                    *[f"    - {p}" for p in self.live_prompts[:5]],
                    "    ...",
                    *[f"    - {p}" for p in self.live_prompts[-5:]],
                    f"  object_prompts ({len(self.object_prompts)}):",
                    *[f"    - {p}" for p in self.object_prompts[:5]],
                    "    ...",
                    *[f"    - {p}" for p in self.object_prompts[-5:]],
                    ")",
                ]
            )
        return "\n".join(
            [
                "SubjectPromptSet(",
                f"  live_prompts ({len(self.live_prompts)}):",
                *[f"    - {p}" for p in self.live_prompts],
                f"  object_prompts ({len(self.object_prompts)}):",
                *[f"    - {p}" for p in self.object_prompts],
                ")",
            ]
        )


SIMPLE_SET = SubjectPromptSet(
    live_prompts=[
        "A {} in the jungle",
        "A {} in the snow",
        "A {} on the beach",
        "A {} on a cobblestone street",
        "A {} on top of pink fabric",
        "A {} on top of a wooden floor",
        "A {} with a city in the background",
        "A {} with a mountain in the background",
        "A {} with a blue house in the background",
        "A {} on top of a purple rug in a forest",
        "A {} wearing a red hat",
        "A {} wearing a santa hat",
        "A {} wearing a rainbow scarf",
        "A {} wearing a black top hat and a monocle",
        "A {} in a chef outfit",
        "A {} in a police outfit",
        "A {} wearing pink glasses",
        "A {} wearing a yellow shirt",
        "A {} in a purple wizard outfit",
        "A red {}",
        "A purple {}",
        "A wet {}",
        "A {} with Japanese modern city street in the background",
        "A {} with a landscape from the Moon",
        "A {} among the skyscrapers in New York city",
        "A {} with a beautiful sunset",
        "A {} in a movie theater",
        "A {} in a luxurious interior living room",
        "A {} in a dream of a distant galaxy",
        "A {} wearing a spacesuit, planting a flag on the moon",
        "A {} as a firefighter, extinguishing a fire in a skyscraper",
        "A {} in a wetsuit, surfing a giant wave in the ocean",
        "A {} in Victorian attire, attending a tea party in an elegant garden",
        "A {} in a snowsuit, skiing down a steep mountain",
        "A {} as an explorer, navigating through an icy Arctic landscape",
        "A {} in an elegant masquerade mask at a Venetian ball",
        "A {} gazing out over a misty mountain range",
        "A {} standing proudly in a field of sunflowers",
        "A {} exploring a vibrant coral reef underwater",
        "A {} relaxing in a hammock under palm trees at sunset",
    ],
    object_prompts=[
        "A {} in the jungle",
        "A {} in the snow",
        "A {} on the beach",
        "A {} on a cobblestone street",
        "A {} on top of pink fabric",
        "A {} on top of a wooden floor",
        "A {} with a city in the background",
        "A {} with a mountain in the background",
        "A {} with a blue house in the background",
        "A {} on top of a purple rug in a forest",
        "A {} with a wheat field in the background",
        "A {} with a tree and autumn leaves in the background",
        "A {} with the Eiffel Tower in the background",
        "A {} floating on top of water",
        "A {} floating in an ocean of milk",
        "A {} on top of green grass with sunflowers around it",
        "A {} on top of a mirror",
        "A {} on top of the sidewalk in a crowded street",
        "A {} on top of a dirt road",
        "A {} on top of a white rug",
        "A red {}",
        "A purple {}",
        "A shiny {}",
        "A wet {}",
        "A {} with Japanese modern city street in the background",
        "A {} with a landscape from the Moon",
        "A {} among the skyscrapers in New York city",
        "A {} with a beautiful sunset",
        "A {} in a movie theater",
        "A {} in a luxurious interior living room",
        "A {} in a dream of a distant galaxy",
        "A photo of {} with ribbons",
        "A photo of golden {}",
        "A photo of {} made out of leathers",
        "A {} in a dense fog",
        "A {} under a starry night sky",
        "A {} beside a rushing waterfall",
        "A {} in a field of wildflowers",
        "A {} with a futuristic cityscape in the background",
        "A {} near the pyramids of Egypt",
    ],
)


COMPLEX_SET = SubjectPromptSet(
    live_prompts=[
        "A {} wearing a wizard costume and holding a Jack-o-lantern, photorealistic digital art",
        "A {} in a superhero costume flying over a cityscape, comic book style",
        "A {} abandoned on a music stage, illuminated by a spotlight",
        "Pop-art style illustration of {}, vibrant neon colors",
        "A pencil sketch of {} filled with flowers in the background, intricate details, black and white",
        "A {} in a fantasy forest, bioluminescent plants, glowing effects, digital painting",
        "A {} in a futuristic city, neon lights, cyberpunk style, digital art",
        "A {} in a medieval village, cobblestone streets, rustic buildings, oil painting",
        "A {} having a cup of tea, Baroque painting with intricate details and rich colors",
        "A vintage-style photograph of {} reading a book by a window",
        "A {} dancing under the moonlight in a ballroom, romantic lighting, impressionist style",
        "A {} wearing steampunk goggles in a Victorian laboratory, sepia tones, detailed machinery",
        "A {} surfing on ocean waves during sunset, dynamic action pose, watercolor painting",
        "A {} dressed as a pirate on a ship deck, stormy seas in background, dramatic lighting",
        "A {} meditating in a zen garden, peaceful atmosphere, minimalist composition, soft pastels",
        "A {} playing guitar around a campfire, stars visible overhead, warm orange glow",
        "A {} exploring ancient ruins, archaeological adventure, Indiana Jones style lighting",
        "A {} as a detective in a film noir scene, black and white photography, venetian blind shadows",
        "A {} ice skating on a frozen lake, winter wonderland setting, crystalline effects",
        "A {} painting at an easel in an art studio, natural lighting, Renaissance style"
    ],
    object_prompts=[
        "A {} decorated with wizard symbols and surrounded by Jack-o-lanterns, photorealistic digital art",
        "A {} designed with superhero motifs overlooking a cityscape, comic book style",
        "A {} placed on a music stage, illuminated by a spotlight",
        "Pop-art style illustration of {}, vibrant neon colors",
        "A pencil sketch of {} surrounded by flowers in the background, intricate details, black and white",
        "A {} in a fantasy forest setting, bioluminescent plants around it, glowing effects, digital painting",
        "A {} in a futuristic city environment, neon lights reflecting off its surface, cyberpunk style, digital art",
        "A {} in a medieval village square, cobblestone streets visible, rustic buildings, oil painting",
        "A {} on an ornate table with tea settings, Baroque painting with intricate details and rich colors",
        "A vintage-style photograph of {} next to an open book by a window",
        "A {} in an elegant ballroom under moonlight streaming through windows, romantic lighting, impressionist style",
        "A {} with steampunk modifications in a Victorian laboratory, sepia tones, detailed machinery around it",
        "A {} on a beach with ocean waves at sunset, dynamic scene, watercolor painting",
        "A {} decorated with pirate themes on a ship deck, stormy seas in background, dramatic lighting",
        "A {} in a zen garden setting, peaceful atmosphere, minimalist composition, soft pastels",
        "A {} near a campfire with guitar silhouettes, stars visible overhead, warm orange glow",
        "A {} among ancient ruins and archaeological tools, adventure expedition style, cinematic lighting",
        "A {} in a film noir detective's office, black and white photography, venetian blind shadows",
        "A {} on a frozen lake in a winter wonderland setting, crystalline ice effects around it",
        "A {} in an art studio next to painting easels, natural lighting, Renaissance style setting"
    ]
)


class StylePrompts(UserList):
    def __init__(self, styles: list[str]) -> None:
        super().__init__(styles)

    def __repr__(self) -> str:
        # If the list is too long, truncate the output
        if len(self.data) > 10:
            return "\n".join(
                [
                    "StylePrompts(",
                    f"  styles ({len(self.data)}):",
                    *[f"    - {p}" for p in self.data[:5]],
                    "    ...",
                    *[f"    - {p}" for p in self.data[-5:]],
                    ")",
                ]
            )
        return "\n".join(
            [
                "StylePrompts(",
                f"  styles ({len(self.data)}):",
                *[f"    - {p}" for p in self.data],
                ")",
            ]
        )


STYLE_SET = [
    "A toothbrush in {} style",
    "A water bottle in {} style",
    "A kitchen sink in {} style",
    "A laptop charger in {} style",
    "A coffee mug in {} style",
    "A computer in {} style",
    "A dog in {} style",
    "A light bulb in {} style",
    "A cat in {} style",
    "A hairbrush in {} style",
    "A desk lamp in {} style",
    "A garden hose in {} style",
    "A microwave oven in {} style",
    "A floor lamp in {} style",
    "A shower curtain in {} style",
    "A salt shaker in {} style",
    "A ceiling fan in {} style",
    "A electric kettle in {} style",
    "A grocery bag in {} style",
    "A laundry basket in {} style",
    "A remote control in {} style",
    "A houseplant in {} style",
    "An orange in {} style",
    "A chocolate cake in {} style",
    "A refrigerator in {} style",
    "A sofa in {} style",
    "An elephant in {} style",
    "A door knob in {} style",
    "A backpack in {} style",
    "A penguin in {} style",
    "A bathrobe in {} style",
    "A cereal bowl in {} style",
    "A wall clock in {} style",
    "A swimmer in {} style",
    "A tablecloth in {} style",
    "A light switch in {} style",
    "A cloud in {} style",
    "A flower vase in {} style",
    "A teddy bear in {} style",
    "A horse in {} style   ",
]


ALL_PROMPT_SETS = {
    "simple": SIMPLE_SET,
    "complex": COMPLEX_SET,
    "style": StylePrompts(STYLE_SET),
}
