#[cfg(not(target_env = "msvc"))]
use jemallocator::Jemalloc;

#[cfg(not(target_env = "msvc"))]
#[global_allocator]
static GLOBAL: Jemalloc = Jemalloc;

mod experiments;
mod gradient;
mod tool;
mod model;
mod uld;

use crate::experiments::australian::*;
use crate::experiments::german::*;
use crate::experiments::mushrooms::*;
use crate::experiments::phishing::*;
use crate::experiments::unbias_rmm_gaussian_model::*;

fn main() -> anyhow::Result<()> {
    // less than 1min
    println!("scaling of trajectory mean error to the step size.");
    gaussian_model_plot_scale4_data()?;
    // less than 3min
    println!("australian scale of trajectory error");
    australian_scale_data()?;
    // less than 5 hours
    println!("phishing scale of trajectory error");
    phishing_scale_data()?;
    // less tan 5 hours
    println!("mushrooms scale of trajectory error");
    mushrooms_scale_data()?;
    // less than 20 min
    println!("german scale of trajectory error");
    german_scale_data()?;
    // less than 12 min
    println!("australian scale step size dependency small");
    australian_scale3_data()?;
    println!("Effect of batch size.");
    // 1 hour 16 min
    australian_scale2_data()?;
    println!("For sampling");
    // less than 1min
    australian_plot_data()?;
    // less than 1min
    phishing_plot_data()?;
    // less than 1min
    german_plot_data()?;
    // less than 1min
    mushrooms_plot_data()?;
    println!("how many segments are enough");
    // less than 1 hour 20 min
    gaussian_model_plot_scale3_data()?;

    Ok(())
}
