import yaml
import re
from dotmap import DotMap
# from ml_collections.config_flags.examples.define_config_dataclass_basic import config


def load_config(config_fname):
    """Load training configuration and random seed of experiment."""
    def load_yaml(config_name: str) -> dict:
        """Load in YAML config file."""
        loader = yaml.SafeLoader
        loader.add_implicit_resolver(
            "tag:yaml.org,2002:float",
            re.compile(
                """^(?:
            [-+]?[0-9][0-9_]*\\.[0-9_]*(?:[eE][-+]?[0-9]+)?
            |[-+]?[0-9][0-9_]*[eE][-+]?[0-9]+
            |\\.[0-9_]+(?:[eE][-+][0-9]+)?
            |[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*
            |[-+]?\\.(?:inf|Inf|INF)
            |\\.(?:nan|NaN|NAN))$""",
                re.X,
            ),
            list("-+0123456789."),
        )
        with open(config_name) as file:
            yaml_config = yaml.load(file, Loader=loader)
        return yaml_config

    config = load_yaml(config_fname)
    return DotMap(config)

config_path = './configs/bp-cnn-cifar10.yaml'
# config_path = './configs/bp-cnn.yaml'
config = load_config(config_path)
