import wandb

def save_code():
    code_art = wandb.Artifact('code', type='code')
    code_art.add_dir('./backprop', name='backprop')
    code_art.remove('backprop/__pycache__')
    code_art.add_dir('./utils', name='utils')
    code_art.remove('utils/__pycache__')
    code_art.add_dir('./evosax/strategies', name='strategies')
    # code_art.remove('evosax/strategies/__pycache__')
    wandb.log_artifact(code_art)


import pandas as pd
import matplotlib.pyplot as plt
def wandb_plot(file_path, plot_name, plot_title, x_label, y_label, column_labels, col_index):

    # Load the dataset
    df = pd.read_csv(file_path)

    # Drop columns containing '__MIN' and '__MAX'
    filtered_df = df.drop([col for col in df.columns if '__MIN' in col or '__MAX' in col], axis=1)

    # Set 'Step' as the index for plotting
    filtered_df.set_index('Step', inplace=True)

    # Rearrange the columns based on the provided column index
    filtered_df = filtered_df[[filtered_df.columns[i] for i in col_index]]


    # Define a new color palette for better distinction
    colors = ['#0077b6', '#ff6347', '#2ca02c', '#d62728', '#8a2be2']

    # Plot the filtered data with bolder lines, distinguishable colors, and custom labels
    plt.figure(figsize=(10, 6))

    # Plot the data with the new color scheme
    filtered_df.plot(color=colors, linewidth=2.5)

    # Update the title and axis labels
    plt.title(plot_title, fontsize=20, pad=0, fontweight='bold')
    plt.xlabel(x_label, fontsize=20, labelpad=0, fontweight='bold')
    plt.ylabel(y_label, fontsize=20, labelpad=0, fontweight='bold')

    # Make title and labels more readable


    # Set the x-axis lower limit to -5 and upper limit to 200
    plt.xlim(-5, 200)

    # Set the legend with the custom labels and bold text
    # plt.legend()
    plt.legend(column_labels, loc='lower right',
               prop={
                   'weight': 'bold',
                     'size': 16
               })
               #(0.34, 0.1)
               # fontsize=13)
    #    legend=plt.legend()
    # for text in legend.get_texts():
    #     text.set_fontweight('bold')
    # multiply y axis ticks by 100
    plt.gca().set_yticklabels([f'{x*100:.0f}' for x in plt.gca().get_yticks()])

    # Add finer gridlines and adjust the background color
    plt.grid(True, which='both', linestyle='--', linewidth=0.5)
    plt.minorticks_on()  # Enable minor ticks for a finer grid
    plt.grid(True, which='minor', linestyle=':', linewidth=0.3)  # Add minor gridlines
    plt.gca().set_facecolor('#f7f7f7')  # Light background

    # make ticks larger
    plt.xticks(fontsize=14, fontweight='bold')
    plt.yticks(fontsize=14, fontweight='bold')

    # Use tight layout for better appearance
    plt.tight_layout()


    # Save the plot as a PDF file
    plt.savefig(f'{plot_name}.pdf')
    plt.show()