#Implementation of MXMNet+MCM

## Requirements
CUDA : 10.2
Python : 3.8

The other dependencies can be installed with:
```
pip install -r requirements.txt
```
## How to run

It is required to produce one extend file `extend_qm9.pt` that contained node featured learned by Motif Convolution Layer (MCL).
Such file could be generated by running `extend_pyg.py` in `graph_match` folder. 

```
python main.py --target 0 --n_layer 6 --extend-file "extend_qm9.pt"   --batch_size 128 --cutoff 5.0  --lr 1e-3
```
Optional arguments:
```
  --extend-file     Path for the file with node features learned by MCL.
  --gpu             GPU number
  --seed            random seed (default: 920)
  --epochs          number of epochs to train
  --lr              initial learning rate
  --wd              weight decay value
  --n_layer         number of hidden layers
  --dim             size of input hidden units
  --batch_size      batch size
  --target          index of target (0~11 except 4)  for prediction on QM9
  --cutoff          distance cutoff used in the global layer
```

## Acknowledgment
Part of code is modified from [MXMNet](https://arxiv.org/abs/2011.07457). 
Thanks to Shuo Zhang for giving instructions on reproducing their work.

