#!/bin/bash

set -x
set -e

export CUDA_VISIBLE_DEVICES=1

data_dir=$1
prediction_dir=$2

if [[ $data_dir == *"dailylifeapis"* ]]; then
    ignore_tool_type=true
else
    ignore_tool_type=false
fi

for file in $data_dir/$prediction_dir/*.json
do
    llm=$(basename $file .json)
    metrics=$(echo $prediction_dir | sed 's/predictions/metrics/g')
    metrics=${metrics}_alignment_all
    if [ -f $data_dir/$metrics/${llm}.json ] && [ -s $data_dir/$metrics/${llm}.json ];
    then
        continue
    fi
    echo $llm
    python evaluate.py --data_dir $data_dir --prediction_dir $prediction_dir --llm $llm --splits all --n_tools all --mode add --ignore_tool_type $ignore_tool_type -m all --alignment all 
done