%%%%%% with uniform scheduler

d = 10;
k = d;
n = 10000;
batchsize = 1;
tol = 1e-4;
ops = configure(d,k,n);
ops.maxiter = n;
ops.miniter = 100;
ops.batchsize = batchsize;
[ops.T, ops.samples] = generateSample(ops);

% initialization
Point_new = orth(randn(d,k));

a=0.007;
b=0.01;
for iter = 1: ops.maxiter
    Point_old = Point_new;
    samples = OneSample(ops,ops.batchsize);
    ops.stepsize=a + (b - a) * rand();
    for kk=1: ops.k
        tmp_out = zeros(size(Point_old,1),1);
        for indx_minibatch = 1: ops.batchsize
            thissample = samples(indx_minibatch,:);
            tmp_out = tmp_out + SGD_component_forbeniousNorm(Point_new,kk,thissample);
        end
        tmp_out = tmp_out./ops.batchsize;
        this_Point_new = Point_old(:,kk) - ops.stepsize * tmp_out;
        Point_new(:,kk) = this_Point_new./sqrt(sum(this_Point_new.^2));
    end
    % check reconstruction error
    T_est = reconstruct(Point_new);
    err_reconst(iter) = sum(sum(sum(sum((ops.T - T_est).^2))))/sum(sum(sum(sum((ops.T ).^2))));
    % check convergence
    err_converge(iter) = norm(Point_new - Point_old)/norm(Point_new);
end

figure(1)
plot(1:iter, err_reconst, 'k-');
xlabel('Iterations')
ylabel('Reconstruction error')
legend('Uniform LR')
grid on


