import datasets
from .task import register, Task
import random
@register('oppopair')
class oppopair(Task):
    VERSION = 0
    DATASET_PATH = "json"
    DATASET_NAME = None

    # cache_dir = "./cache"
    train_files = './data/verb_oppo/oppo_train.json'
    test_files = './data/verb_oppo/oppo_test.json'

    def download(self, data_dir=None, cache_dir=None, download_mode=None):
       
        testset = datasets.load_dataset(
            path=self.DATASET_PATH,
            name=self.DATASET_NAME,
            data_files=self.test_files,
            cache_dir=cache_dir,
            download_mode=download_mode,
            split = "train"
        )

        trainset = datasets.load_dataset(
            path=self.DATASET_PATH,
            name=self.DATASET_NAME,
            data_files=self.train_files,
            cache_dir=cache_dir,
            download_mode=download_mode,
            split = "train"
        )

        self.dataset = datasets.DatasetDict({
            "train": trainset,
            "validation": testset
        })

    def has_training_docs(self):
        return True

    def has_validation_docs(self):
        return True

    def has_test_docs(self):
        return False

    def training_docs(self):
        if self._training_docs is None:
            self._training_docs = list(self.dataset["train"])
        return self._training_docs

    def validation_docs(self):
        return self.dataset["validation"]

    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: * {doc['input']}\noutput: "
        return inp

    def doc_to_target(self, doc):
        return doc["output"]


@register('oppopair_swap')
class oppopair_swap(oppopair):
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup

@register('oppopair_swap_com')
class oppopair_swap_com(oppopair):
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: * {doc['input']}\noutput: "
        return inp
    def doc_to_textcot1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"* {doc['input']} "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_targetcot1(self, doc):
        doc["input"] = doc["output"]
        return doc
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: {a} # {b} #\noutput: "
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} #"
        return inp
    def doc_to_textcot2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} # "
        return inp
    def doc_to_target2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    
    def doc_to_targetcot2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        doc['input'] = oup
        return doc
    
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: * {doc['input']} #\noutput: "
        return inp

    
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup


    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = 0, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example


@register('oppopair_swap_com_incontext')
class oppopair_swap_com_incontext(oppopair_swap_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_tag')
class oppopair_swap_com_incontext_tag(oppopair_swap_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        "(simple1)" + self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        "(simple2)" + self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        "(compose)" + self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = "(compose)" + self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_cot')
class oppopair_swap_com_incontext_cot(oppopair_swap_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text2(doc) + " -> " + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + " -> " + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example

@register('oppopair_swap_com_incontext_expcot')
class oppopair_swap_com_incontext_expcot(oppopair_swap_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"step1: * {doc['input']}\nstep2: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_target1new(self, doc):
        return doc["output"]# + "\nstep3:"
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: {a} # {b} #\noutput: "
        inp = f"step1: {doc['input']} #\nstep2: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} #\nstep3:"
        return inp
    def doc_to_target2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"step1: * {doc['input']} #\nstep2: "
        return inp
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #\nstep3:"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + self.doc_to_target_rand(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        "step1:???\nstep2: " + self.doc_to_text2new(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1new(doc) + "\nstep3:???"
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_re1')
class oppopair_swap_com_incontext_re1(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_irrl')
class oppopair_swap_com_incontext_irrl(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text3(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_irrl_fixop')
class oppopair_swap_com_incontext_irrl_fixop(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_irrl_fixcontent')
class oppopair_swap_com_incontext_irrl_fixcontent(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text3(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text3(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_re1_cot')
class oppopair_swap_com_incontext_re1_cot(oppopair_swap_com):
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(self.doc_to_targetcot2(doc))
        else:
            return self.doc_to_textcot2(self.doc_to_targetcot1(doc))
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_rand(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ]
            
            #rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('oppopair_swap_com_incontext_special')
class oppopair_swap_com_incontext_special(oppopair_swap_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        #print(labeled_examples)
        #"input: Fail Enemy #\noutput: Enemy Fail\n\ninput: Ignore Junior #\noutput: Junior Ignore\n\ninput: Married Guilty #\noutput: Guilty Married\n\ninput: * Ordinary Harsh\noutput: Extraordinary Mild\n\ninput: * Eager Proud\noutput: Reluctant Humble\n\ninput: * Rich Humble\noutput: Poor Proud\n\ninput: Start Famous #\noutput: Famous Start\n\ninput: * Wide Light #\noutput: Dark Narrow\n\ninput: * Dry Lie\noutput: Wet Stand\n\ninput: * Glad Flat\noutput: Sad Hilly\n\ninput: * Regular Lose #\noutput: Win Irregular\n\ninput: * Front Happy #\noutput: Sad Back\n\ninput: * Divide Legal #\noutput: Illegal Unite\n\ninput: First Interest #\noutput: Interest First\n\ninput: * Far Land\noutput: Near Sea\n\ninput: * Sad Less\noutput: Happy More\n\ninput: Excited Day #\noutput: Day Excited\n\ninput: * Freeze Yes\noutput: Melt No\n\ninput: Miss Accept #\noutput: Accept Miss\n\ninput: * Black Expensive\noutput: White Cheap\n\ninput: Join Difficult #\noutput: Difficult Join\n\ninput: Regular Dirty #\noutput: Dirty Regular\n\ninput: * Intentional Divide #\noutput: Unite Accidental\n\ninput: Decrease Minor #\noutput: Minor Decrease\n\ninput: * Live Destroy\noutput: Die Build\n\n"
            

        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example
@register('oppopair_swap_com_incontext_special_shuffle')
class oppopair_swap_com_incontext_special_shuffle(oppopair_swap_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        rnd.shuffle(prompt_list)
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n")
        aa = []
        for i in range(len(prompt_list)):
            aa.append(0)
        for i in range(len(prompt_list)):
            items = prompt_list[i]
            if ('*' in items) and ('#' in items):
                aa[i] = 0
            elif ('*' in items):
                aa[i] = 1
            else:
                aa[i] = 2
        #print(labeled_examples)
        #"input: Fail Enemy #\noutput: Enemy Fail\n\ninput: Ignore Junior #\noutput: Junior Ignore\n\ninput: Married Guilty #\noutput: Guilty Married\n\ninput: * Ordinary Harsh\noutput: Extraordinary Mild\n\ninput: * Eager Proud\noutput: Reluctant Humble\n\ninput: * Rich Humble\noutput: Poor Proud\n\ninput: Start Famous #\noutput: Famous Start\n\ninput: * Wide Light #\noutput: Dark Narrow\n\ninput: * Dry Lie\noutput: Wet Stand\n\ninput: * Glad Flat\noutput: Sad Hilly\n\ninput: * Regular Lose #\noutput: Win Irregular\n\ninput: * Front Happy #\noutput: Sad Back\n\ninput: * Divide Legal #\noutput: Illegal Unite\n\ninput: First Interest #\noutput: Interest First\n\ninput: * Far Land\noutput: Near Sea\n\ninput: * Sad Less\noutput: Happy More\n\ninput: Excited Day #\noutput: Day Excited\n\ninput: * Freeze Yes\noutput: Melt No\n\ninput: Miss Accept #\noutput: Accept Miss\n\ninput: * Black Expensive\noutput: White Cheap\n\ninput: Join Difficult #\noutput: Difficult Join\n\ninput: Regular Dirty #\noutput: Dirty Regular\n\ninput: * Intentional Divide #\noutput: Unite Accidental\n\ninput: Decrease Minor #\noutput: Minor Decrease\n\ninput: * Live Destroy\noutput: Die Build\n\n"
            

        example = self.doc_to_text(doc)
        prompt_listg = prompt_list.copy()
        prompt_listg.append(example)
        aa.append(3)
        return description + labeled_examples + example, prompt_listg, aa, example
#"* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: * Hire Mature #\noutput: Immature Fire\n\ninput: Long Front #\noutput: Front Long\n\ninput: * East Fixed #\noutput: Broken West\n\ninput: Hurry Combine #\noutput: Combine Hurry\n\ninput: * Scatter Even #\noutput: Odd Gather\n\ninput: * Large Cool\noutput: Small Warm\n\ninput: * High Miss\noutput: Low Hit\n\ninput: * Scarce Equal\noutput: Abundant Different\n\ninput: * Sad Dry #\noutput: Wet Happy\n\ninput: * Sharp Guilty #\noutput: Innocent Dull\n\ninput: * Cool Advance\noutput: Warm Retreat\n\ninput: Accept Safe #\noutput: Safe Accept\n\ninput: * Past Complicated #\noutput: Simple Future\n\ninput: * Equal Dry #\noutput: Wet Different\n\ninput: * Messy Illegal #\noutput: Legal Neat\n\ninput: * Pass Peace\noutput: Fail War\n\ninput: * Ignore Related #\noutput: Unrelated Notice\n\ninput: * Advance Gentle #\noutput: Rough Retreat\n\ninput: * Original Night #\noutput: Day Copy\n\ninput: Permanent Complicated #\noutput: Complicated Permanent\n\ninput: Buy Create #\noutput: Create Buy\n\ninput: * Real Order #\noutput: Chaos Fake\n\ninput: * Bright Hire\noutput: Dim Fire\n\ninput: * Give Pretty #\noutput: Ugly Take\n\ninput: * Free Organized #\noutput: Disorganized Expensive\n\ninput: * Science Clear #\noutput: Cloudy Art\n\ninput: Forget Advance #\noutput: Advance Forget\n\ninput: * Hot Love #\noutput: Hate Cold\n\ninput: * Heavy Harsh #\noutput: Mild Light\n\ninput: * Rich Nothing\noutput: Poor Everything\n\ninput: * Insult Grant #\noutput: Refuse Compliment\n\ninput: * Enter Hit\noutput: Exit Miss\n\ninput: * Scatter Part\noutput: Gather Whole\n\ninput: Brave Deep #\noutput: Deep Brave\n\ninput: New North #\noutput: North New\n\ninput: * Accept Scarce\noutput: Reject Abundant\n\ninput: Clear Ordinary #\noutput: Ordinary Clear\n\ninput: * Lie Learn #\noutput: Forget Stand\n\ninput: * Defeat Begin #\noutput: End Victory\n\ninput: Leader Outside #\noutput: Outside Leader\n\n"
#"* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: ( Hire Mature )\noutput: HIRE MATURE\n\ninput: Long Front #\noutput: Front Long\n\ninput: ( East Fixed )\noutput: EAST FIXED\n\ninput: Hurry Combine #\noutput: Combine Hurry\n\ninput: ( Scatter Even )\noutput: SCATTER EVEN\n\ninput: * Large Cool\noutput: Small Warm\n\ninput: * High Miss\noutput: Low Hit\n\ninput: * Scarce Equal\noutput: Abundant Different\n\ninput: ( Sad Dry )\noutput: SAD DRY\n\ninput: ( Sharp Guilty )\noutput: SHARP GUILTY\n\ninput: * Cool Advance\noutput: Warm Retreat\n\ninput: Accept Safe #\noutput: Safe Accept\n\ninput: ( Past Complicated )\noutput: PAST COMPLICATED\n\ninput: ( Equal Dry )\noutput: EQUAL DRY\n\ninput: ( Messy Illegal )\noutput: MESSY ILLEGAL\n\ninput: * Pass Peace\noutput: Fail War\n\ninput: ( Ignore Related )\noutput: IGNORE RELATED\n\ninput: ( Advance Gentle )\noutput: ADVANCE GENTLE\n\ninput: ( Original Night )\noutput: ORIGINAL NIGHT\n\ninput: Permanent Complicated #\noutput: Complicated Permanent\n\ninput: Buy Create #\noutput: Create Buy\n\ninput: ( Real Order )\noutput: REAL ORDER\n\ninput: * Bright Hire\noutput: Dim Fire\n\ninput: ( Give Pretty )\noutput: GIVE PRETTY\n\ninput: ( FREE ORGANIZED )\noutput: Disorganized Expensive\n\ninput: ( Science Clear )\noutput: SCIENCE CLEAR\n\ninput: Forget Advance #\noutput: Advance Forget\n\ninput: ( Hot Love )\noutput: HOT LOVE\n\ninput: ( Heavy Harsh )\noutput: HEAVY HARSH\n\ninput: * Rich Nothing\noutput: Poor Everything\n\ninput: ( Insult Grant )\noutput: INSULT GRANT\n\ninput: * Enter Hit\noutput: Exit Miss\n\ninput: * Scatter Part\noutput: Gather Whole\n\ninput: Brave Deep #\noutput: Deep Brave\n\ninput: New North #\noutput: North New\n\ninput: * Accept Scarce\noutput: Reject Abundant\n\ninput: Clear Ordinary #\noutput: Ordinary Clear\n\ninput: ( Lie Learn )\noutput: LIE LEARN\n\ninput: ( Defeat Begin )\noutput: DEFEAT BEGIN\n\ninput: Leader Outside #\noutput: Outside Leader\n\n"
#"* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: * Hire Mature #\noutput: Immature Fire\n\ninput:( Long Front )\noutput: LONG FRONT\n\ninput: * East Fixed #\noutput: Broken West\n\ninput:( Hurry Combine )\noutput: HURRY COMBINE\n\ninput: * Scatter Even #\noutput: Odd Gather\n\ninput: * Large Cool\noutput: Small Warm\n\ninput: * High Miss\noutput: Low Hit\n\ninput: * Scarce Equal\noutput: Abundant Different\n\ninput: * Sad Dry #\noutput: Wet Happy\n\ninput: * Sharp Guilty #\noutput: Innocent Dull\n\ninput: * Cool Advance\noutput: Warm Retreat\n\ninput:( Accept Safe )\noutput: ACCEPT SAFE\n\ninput: * Past Complicated #\noutput: Simple Future\n\ninput: * Equal Dry #\noutput: Wet Different\n\ninput: * Messy Illegal #\noutput: Legal Neat\n\ninput: * Pass Peace\noutput: Fail War\n\ninput: * Ignore Related #\noutput: Unrelated Notice\n\ninput: * Advance Gentle #\noutput: Rough Retreat\n\ninput: * Original Night #\noutput: Day Copy\n\ninput:( Permanent Complicated )\noutput: PERMANENT COMPLICATED\n\ninput:( Buy Create )\noutput: BUY CREATE\n\ninput: * Real Order #\noutput: Chaos Fake\n\ninput: * Bright Hire\noutput: Dim Fire\n\ninput: * Give Pretty #\noutput: Ugly Take\n\ninput: * Free Organized #\noutput: Disorganized Expensive\n\ninput: * Science Clear #\noutput: Cloudy Art\n\ninput:( Forget Advance )\noutput: FORGET ADVANCE\n\ninput: * Hot Love #\noutput: Hate Cold\n\ninput: * Heavy Harsh #\noutput: Mild Light\n\ninput: * Rich Nothing\noutput: Poor Everything\n\ninput: * Insult Grant #\noutput: Refuse Compliment\n\ninput: * Enter Hit\noutput: Exit Miss\n\ninput: * Scatter Part\noutput: Gather Whole\n\ninput:( Brave Deep )\noutput: BRAVE DEEP\n\ninput:( New North )\noutput: NEW NORTH\n\ninput: * Accept Scarce\noutput: Reject Abundant\n\ninput:( Clear Ordinary )\noutput: CLEAR ORDINARY\n\ninput: * Lie Learn #\noutput: Forget Stand\n\ninput: * Defeat Begin #\noutput: End Victory\n\ninput:( Leader Outside )\noutput: LEADER OUTSIDE\n\n"
@register('oppopair_swap_com_incontext_fix')
class oppopair_swap_com_incontext_fix(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp

    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        labeled_examples =  "* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: Praise Moon #\noutput: Moon Praise\n\ninput: * Divide Legal\noutput: Unite Illegal\n\ninput: * Difficult Praise #\noutput: Criticize Easy\n\ninput: * Married Out #\noutput: In Single\n\ninput: Flat Free #\noutput: Free Flat\n\ninput: * Intentional Forget\noutput: Accidental Remember\n\ninput: * Empty Strong\noutput: Full Weak\n\ninput: Grant Advance #\noutput: Advance Grant\n\ninput: * True Go\noutput: False Come\n\ninput: Major Safe #\noutput: Safe Major\n\ninput: * Reduce Inferior\noutput: Increase Superior\n\ninput: Alive Modern #\noutput: Modern Alive\n\ninput: * Large Regular #\noutput: Irregular Small\n\ninput: * Wide Advance\noutput: Narrow Retreat\n\ninput: * Random Modern\noutput: Specific Ancient\n\ninput: Enter Advance #\noutput: Advance Enter\n\ninput: * Excited In\noutput: Bored Out\n\ninput: Intentional Regret #\noutput: Regret Intentional\n\ninput: Inside Join #\noutput: Join Inside\n\ninput: * True Begin #\noutput: End False\n\ninput: Scatter Responsible #\noutput: Responsible Scatter\n\ninput: * Rich Expensive\noutput: Poor Cheap\n\ninput: * Random Good #\noutput: Evil Specific\n\ninput: * Hire Great\noutput: Fire Terrible\n\ninput: Full Tall #\noutput: Tall Full\n\n"

        example = self.doc_to_text(doc)

        return description + labeled_examples + example, description + labeled_examples
@register('oppopair_swap_com_incontext_fix_re1')
class oppopair_swap_com_incontext_fix_re1(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp

    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        labeled_examples =  "* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: Praise Moon #\noutput: Moon Praise\n\ninput: * Divide Legal\noutput: Unite Illegal\n\ninput: * Difficult Praise #\noutput: Criticize Easy\n\ninput: * Married Out #\noutput: In Single\n\ninput: Flat Free #\noutput: Free Flat\n\ninput: * Intentional Forget\noutput: Accidental Remember\n\ninput: * Empty Strong\noutput: Full Weak\n\ninput: Grant Advance #\noutput: Advance Grant\n\ninput: * True Go\noutput: False Come\n\ninput: Major Safe #\noutput: Safe Major\n\ninput: * Reduce Inferior\noutput: Increase Superior\n\ninput: Alive Modern #\noutput: Modern Alive\n\ninput: * Large Regular #\noutput: Irregular Small\n\ninput: * Wide Advance\noutput: Narrow Retreat\n\ninput: * Random Modern\noutput: Specific Ancient\n\ninput: Enter Advance #\noutput: Advance Enter\n\ninput: * Excited In\noutput: Bored Out\n\ninput: Intentional Regret #\noutput: Regret Intentional\n\ninput: Inside Join #\noutput: Join Inside\n\ninput: * True Begin #\noutput: End False\n\ninput: Scatter Responsible #\noutput: Responsible Scatter\n\ninput: * Rich Expensive\noutput: Poor Cheap\n\ninput: * Random Good #\noutput: Evil Specific\n\ninput: * Hire Great\noutput: Fire Terrible\n\ninput: Full Tall #\noutput: Tall Full\n\n"

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example, description + labeled_examples
@register('oppopair_swap_com_incontext_fix_re2')
class oppopair_swap_com_incontext_fix_re2(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp

    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        labeled_examples =  "* is a function before words for finding the opposite meaning of two words, # is another function after words for swapping the position of 2 words\n\ninput: Praise Moon #\noutput: Moon Praise\n\ninput: * Divide Legal\noutput: Unite Illegal\n\ninput: * Difficult Praise #\noutput: Criticize Easy\n\ninput: * Married Out #\noutput: In Single\n\ninput: Flat Free #\noutput: Free Flat\n\ninput: * Intentional Forget\noutput: Accidental Remember\n\ninput: * Empty Strong\noutput: Full Weak\n\ninput: Grant Advance #\noutput: Advance Grant\n\ninput: * True Go\noutput: False Come\n\ninput: Major Safe #\noutput: Safe Major\n\ninput: * Reduce Inferior\noutput: Increase Superior\n\ninput: Alive Modern #\noutput: Modern Alive\n\ninput: * Large Regular #\noutput: Irregular Small\n\ninput: * Wide Advance\noutput: Narrow Retreat\n\ninput: * Random Modern\noutput: Specific Ancient\n\ninput: Enter Advance #\noutput: Advance Enter\n\ninput: * Excited In\noutput: Bored Out\n\ninput: Intentional Regret #\noutput: Regret Intentional\n\ninput: Inside Join #\noutput: Join Inside\n\ninput: * True Begin #\noutput: End False\n\ninput: Scatter Responsible #\noutput: Responsible Scatter\n\ninput: * Rich Expensive\noutput: Poor Cheap\n\ninput: * Random Good #\noutput: Evil Specific\n\ninput: * Hire Great\noutput: Fire Terrible\n\ninput: Full Tall #\noutput: Tall Full\n\n"

        example = self.doc_to_text2(doc)

        return description + labeled_examples + example, description + labeled_examples
@register('oppopair_swap_com_incontext_distribution')
class oppopair_swap_com_incontext_distribution(oppopair_swap_com):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        #inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc["input"].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example