import datasets
from .task import register, Task
import random
@register('verbpair')
class verbpair(Task):
    VERSION = 0
    DATASET_PATH = "json"
    DATASET_NAME = None

    # cache_dir = "./cache"
    train_files = './data/verb_oppo/verb_train.json'
    test_files = './data/verb_oppo/verb_test.json'

    def download(self, data_dir=None, cache_dir=None, download_mode=None):
       
        testset = datasets.load_dataset(
            path=self.DATASET_PATH,
            name=self.DATASET_NAME,
            data_files=self.test_files,
            cache_dir=cache_dir,
            download_mode=download_mode,
            split = "train"
        )

        trainset = datasets.load_dataset(
            path=self.DATASET_PATH,
            name=self.DATASET_NAME,
            data_files=self.train_files,
            cache_dir=cache_dir,
            download_mode=download_mode,
            split = "train"
        )

        self.dataset = datasets.DatasetDict({
            "train": trainset,
            "validation": testset
        })

    def has_training_docs(self):
        return True

    def has_validation_docs(self):
        return True

    def has_test_docs(self):
        return False

    def training_docs(self):
        if self._training_docs is None:
            self._training_docs = list(self.dataset["train"])
        return self._training_docs

    def validation_docs(self):
        return self.dataset["validation"]

    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: * {doc['input']}\noutput: "
        return inp

    def doc_to_target(self, doc):
        return doc["output"]


@register('verbpair_swap')
class verbpair_swap(verbpair):
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup

@register('verbpair_swap_com')
class verbpair_swap_com(verbpair):
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} * {b}\noutput: "
        inp = f"input: * {doc['input']}\noutput: "
        return inp
    def doc_to_textcot1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} * {b}\noutput: "
        inp = f"* {doc['input']} "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_targetcot1(self, doc):
        doc["input"] = doc["output"]
        return doc
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} #"
        return inp
    def doc_to_textcot2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} # "
        return inp
    def doc_to_target2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    def doc_to_targetcot2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        doc['input'] = oup
        return doc
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: * {doc['input']} #\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup


    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot+num_fewshot2, kc = 0, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example


@register('verbpair_swap_com_incontext')
class verbpair_swap_com_incontext(verbpair_swap_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_tag')
class verbpair_swap_com_incontext_tag(verbpair_swap_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        "(simple1)" + self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        "(simple2)" + self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        "(compose)" + self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = "(compose)" + self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_re1')
class verbpair_swap_com_incontext_re1(verbpair_swap_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: | {doc['input']} |\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_irrl')
class verbpair_swap_com_incontext_irrl(verbpair_swap_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: | {doc['input']} |\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc['input'].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text3(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_irrl_fixop')
class verbpair_swap_com_incontext_irrl_fixop(verbpair_swap_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: | {doc['input']} |\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc['input'].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_irrl_fixcontent')
class verbpair_swap_com_incontext_irrl_fixcontent(verbpair_swap_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: | {doc['input']} |\noutput: "
        return inp
    def doc_to_target3(self, doc):
        return doc['input'].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text3(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text3(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_cot')
class verbpair_swap_com_incontext_cot(verbpair_swap_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return (doc["output"] + " #")
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text2(doc) + " -> " + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + " -> " + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_expcot')
class verbpair_swap_com_incontext_expcot(verbpair_swap_com):
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} * {b}\noutput: "
        inp = f"step1: * {doc['input']}\nstep2: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_target1new(self, doc):
        return doc["output"]# + "\nstep3:"
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: {a} # {b} #\noutput: "
        inp = f"{doc['input']} #\nstep3:"
        return inp
    def doc_to_target2(self, doc):
        pair = doc['input'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"step1: * {doc['input']} #\nstep2: "
        return inp
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        inp = " ".join(pair)
        a, b = pair
        oup = " ".join([b,a])
        return oup
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return (doc["output"] + " #\nstep3:")
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + self.doc_to_target_rand(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        "step1:???\nstep2: " + self.doc_to_text2new(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1new(doc) + "\nstep3:???"
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbpair_swap_com_incontext_special')
class verbpair_swap_com_incontext_special(verbpair_swap_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc)  + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        #rnd.shuffle(prompt_list)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example
@register('verbpair_swap_com_incontext_special_shuffle')
class verbpair_swap_com_incontext_special_shuffle(verbpair_swap_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        return doc["output"] + " #"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        rnd.shuffle(prompt_list)
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n")
        aa = []
        for i in range(len(prompt_list)):
            aa.append(0)
        for i in range(len(prompt_list)):
            items = prompt_list[i]
            if ('*' in items) and ('#' in items):
                aa[i] = 0
            elif ('*' in items):
                aa[i] = 1
            else:
                aa[i] = 2
        #print(labeled_examples)
        #"input: Fail Enemy #\noutput: Enemy Fail\n\ninput: Ignore Junior #\noutput: Junior Ignore\n\ninput: Married Guilty #\noutput: Guilty Married\n\ninput: * Ordinary Harsh\noutput: Extraordinary Mild\n\ninput: * Eager Proud\noutput: Reluctant Humble\n\ninput: * Rich Humble\noutput: Poor Proud\n\ninput: Start Famous #\noutput: Famous Start\n\ninput: * Wide Light #\noutput: Dark Narrow\n\ninput: * Dry Lie\noutput: Wet Stand\n\ninput: * Glad Flat\noutput: Sad Hilly\n\ninput: * Regular Lose #\noutput: Win Irregular\n\ninput: * Front Happy #\noutput: Sad Back\n\ninput: * Divide Legal #\noutput: Illegal Unite\n\ninput: First Interest #\noutput: Interest First\n\ninput: * Far Land\noutput: Near Sea\n\ninput: * Sad Less\noutput: Happy More\n\ninput: Excited Day #\noutput: Day Excited\n\ninput: * Freeze Yes\noutput: Melt No\n\ninput: Miss Accept #\noutput: Accept Miss\n\ninput: * Black Expensive\noutput: White Cheap\n\ninput: Join Difficult #\noutput: Difficult Join\n\ninput: Regular Dirty #\noutput: Dirty Regular\n\ninput: * Intentional Divide #\noutput: Unite Accidental\n\ninput: Decrease Minor #\noutput: Minor Decrease\n\ninput: * Live Destroy\noutput: Die Build\n\n"
            

        example = self.doc_to_text(doc)
        prompt_listg = prompt_list.copy()
        prompt_listg.append(example)
        aa.append(3)
        return description + labeled_examples + example, prompt_listg, aa, example
@register('verbpair_swap_com_incontext_distribution')
class verbpair_swap_com_incontext_distribution(verbpair_swap_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        # inp = f"input: * {a} # * {b} #\noutput: "
        inp = f"input: | {doc['input']} |\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'].upper()
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example