import random
import datasets
from .task import register, Task
from .verbpair import verbpair
import re
@register('verbsingle')
class verbsingle(verbpair):
    train_files = './data/verb_oppo/verb_single_train.json'
    test_files = './data/verb_oppo/verb_single_test.json'

    def doc_to_text(self, doc):
        inp = f"input: * {doc['input']}\noutput: "
        return inp
    
@register('verbsingle_upper')
class verbsingle_upper(verbsingle):
    def doc_to_text(self, doc):
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        return doc['input'].upper()
    
@register('verbsingle_upper_com')
class verbsingle_upper_com(verbsingle):
    def doc_to_text1(self, doc):
        inp = f"input: * {doc['input']}\noutput: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_text2(self, doc):
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        inp = f"{doc['input']} #"
        return inp
    def doc_to_target2(self, doc):
        return doc['input'].upper()
    def doc_to_text(self, doc):
        inp = f"input: * {doc['input']} #\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        return doc['output'].upper()

    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = 0, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example


@register('verbsingle_upper_com_incontext')
class verbsingle_upper_com_incontext(verbsingle_upper_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot + num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot + num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_tag')
class verbsingle_upper_com_incontext_tag(verbsingle_upper_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        "(simple1)" + self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        "(simple2)" + self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        "(compose)" + self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = "(compose)" + self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_re1')
class verbsingle_upper_com_incontext_re1(verbsingle_upper_com_incontext):
    def doc_to_text3(self, doc):
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'] + "essab"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_irrl')
class verbsingle_upper_com_incontext_irrl(verbsingle_upper_com_incontext):
    def doc_to_text3(self, doc):
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'] + "essab"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
            print(len(fewshotex))
            prompt_list = [
                        self.doc_to_text3(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_irrl_fixop')
class verbsingle_upper_com_incontext_irrl_fixop(verbsingle_upper_com_incontext):
    def doc_to_text3(self, doc):
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'] + "essab"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
            print(len(fewshotex))
            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_irrl_fixcontent')
class verbsingle_upper_com_incontext_irrl_fixcontent(verbsingle_upper_com_incontext):
    def doc_to_text3(self, doc):
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'] + "essab"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
            print(len(fewshotex))
            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text3(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text3(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_distribution')
class verbsingle_upper_com_incontext_distribution(verbsingle_upper_com_incontext):
    def doc_to_text3(self, doc):
        inp = f"input: ( {doc['input']} )\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        return doc['input'] + "essab"
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
            print(len(fewshotex))
            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_cot')
class verbsingle_upper_com_incontext_cot(verbsingle_upper_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        c = self.doc_to_target2(doc)
        inp = f"* {c}"
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text2(doc) + " -> " + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + " -> " + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_expcot')
class verbsingle_upper_com_incontext_expcot(verbsingle_upper_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_text1(self, doc):
        inp = f"step1: * {doc['input']}\nstep2: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_target1new(self, doc):
        return doc["output"]# + "\nstep3:"
    def doc_to_text2(self, doc):
        inp = f"input: {doc['input']} #\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        inp = f"{doc['input']} #\nstep3:"
        return inp
    def doc_to_target2(self, doc):
        return doc['input'].upper()
    def doc_to_text(self, doc):
        inp = f"step1: * {doc['input']} #\nstep2:"
        return inp
    
    def doc_to_target(self, doc):
        return doc['output'].upper()
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        c = self.doc_to_target1(doc)
        inp = f"{c} #\nstep3:"
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + self.doc_to_target_rand(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        "step1:???\nstep2: " + self.doc_to_text2new(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1new(doc) + "\nstep3:???"
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_upper_com_incontext_special')
class verbsingle_upper_com_incontext_special(verbsingle_upper_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        c = self.doc_to_target2(doc)
        inp = f"* {c}"
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        #rnd.shuffle(prompt_list)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example
@register('verbsingle_upper_com_incontext_special')
class verbsingle_upper_com_incontext_special(verbsingle_upper_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        c = self.doc_to_target2(doc)
        inp = f"* {c}"
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        #rnd.shuffle(prompt_list)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example
@register('verbsingle_upper_com_incontext_special_shuffle')
class verbsingle_upper_com_incontext_special_shuffle(verbsingle_upper_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        c = self.doc_to_target2(doc)
        inp = f"* {c}"
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        rnd.shuffle(prompt_list)
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n")
        aa = []
        for i in range(len(prompt_list)):
            aa.append(0)
        for i in range(len(prompt_list)):
            items = prompt_list[i]
            if ('*' in items) and ('#' in items):
                aa[i] = 0
            elif ('*' in items):
                aa[i] = 1
            else:
                aa[i] = 2
        #print(labeled_examples)
        #"input: Fail Enemy #\noutput: Enemy Fail\n\ninput: Ignore Junior #\noutput: Junior Ignore\n\ninput: Married Guilty #\noutput: Guilty Married\n\ninput: * Ordinary Harsh\noutput: Extraordinary Mild\n\ninput: * Eager Proud\noutput: Reluctant Humble\n\ninput: * Rich Humble\noutput: Poor Proud\n\ninput: Start Famous #\noutput: Famous Start\n\ninput: * Wide Light #\noutput: Dark Narrow\n\ninput: * Dry Lie\noutput: Wet Stand\n\ninput: * Glad Flat\noutput: Sad Hilly\n\ninput: * Regular Lose #\noutput: Win Irregular\n\ninput: * Front Happy #\noutput: Sad Back\n\ninput: * Divide Legal #\noutput: Illegal Unite\n\ninput: First Interest #\noutput: Interest First\n\ninput: * Far Land\noutput: Near Sea\n\ninput: * Sad Less\noutput: Happy More\n\ninput: Excited Day #\noutput: Day Excited\n\ninput: * Freeze Yes\noutput: Melt No\n\ninput: Miss Accept #\noutput: Accept Miss\n\ninput: * Black Expensive\noutput: White Cheap\n\ninput: Join Difficult #\noutput: Difficult Join\n\ninput: Regular Dirty #\noutput: Dirty Regular\n\ninput: * Intentional Divide #\noutput: Unite Accidental\n\ninput: Decrease Minor #\noutput: Minor Decrease\n\ninput: * Live Destroy\noutput: Die Build\n\n"
            

        example = self.doc_to_text(doc)
        prompt_listg = prompt_list.copy()
        prompt_listg.append(example)
        aa.append(3)
        return description + labeled_examples + example, prompt_listg, aa, example
### plusOne
import hashlib
import random

def deterministic_random(doc_id):
    # Convert the doc_id to a string and encode it to bytes
    doc_id_str = str(doc_id).encode('utf-8')
    
    # Use a hash function to generate a hash value from the doc_id
    hash_value = hashlib.sha256(doc_id_str).hexdigest()
    
    # Convert the first few characters of the hash to an integer
    # This serves as a deterministic seed value based on the doc_id
    seed_value = int(hash_value[:8], 16)
    
    # Use the seed to initialize the random number generator
    random.seed(seed_value)
    
    # Generate and return a random number between 1 and 1000
    return random.randint(1, 1000)

@register('verbsingle_word')
class verbsingle_word(verbpair):
    train_files = './data/verb_oppo/verb_single_train.json'
    test_files = './data/verb_oppo/verb_single_test.json'

    def doc_to_text(self, doc):
        inp = f"input:{doc['input']}\noutput: "
        return inp

@register('verbsingle_plusOne')
class verbsingle_plusOne(verbsingle):
    def doc_to_text(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num}\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        num = deterministic_random(doc['input'])
        return str(num + 1)
    
@register('verbsingle_plusOne_com')
class verbsingle_plusOne_com(verbsingle_plusOne):
    def doc_to_text1(self, doc):
        inp = f"input: {doc['input']}\noutput: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_text2(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num}\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"{num}"
        return inp
    def new(self, doc):
        inpp = doc['input'].split(' ')
        num = deterministic_random(doc['input'])
        inp = str(num + 1) + ' ' + inpp[-1]
        return inp
    def doc_to_target2(self, doc):
        num = deterministic_random(doc['input'])
        return str(num + 1)
    def doc_to_text(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} {doc['input']}\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num + 1} {doc['output']}"
        return oup

    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,  kc = 0, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example


@register('verbsingle_plusOne_com_incontext')
class verbsingle_plusOne_com_incontext(verbsingle_plusOne_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_tag')
class verbsingle_plusOne_com_incontext_tag(verbsingle_plusOne_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        "(simple1)" + self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        "(simple2)" + self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        "(compose)" + self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = "(compose)" + self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_re1')
class verbsingle_plusOne_com_incontext_re1(verbsingle_plusOne_com_incontext):
    def doc_to_text3(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} || {doc['input']}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num * 5} {doc['input'] + 'essab'}"
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_irrl')
class verbsingle_plusOne_com_incontext_irrl(verbsingle_plusOne_com_incontext):
    def doc_to_text3(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} || {doc['input']}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num * 5} {doc['input'] + 'essab'}"
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text3(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_irrl_fixop')
class verbsingle_plusOne_com_incontext_irrl_fixop(verbsingle_plusOne_com_incontext):
    def doc_to_text3(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} || {doc['input']}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num * 5} {doc['input'] + 'essab'}"
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_irrl_fixcontent')
class verbsingle_plusOne_com_incontext_irrl_fixcontent(verbsingle_plusOne_com_incontext):
    def doc_to_text3(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} || {doc['input']}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num * 5} {doc['input'] + 'essab'}"
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text3(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text3(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_distribution')
class verbsingle_plusOne_com_incontext_distribution(verbsingle_plusOne_com_incontext):
    def doc_to_text3(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num} || {doc['input']}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num * 5} {doc['input'] + 'essab'}"
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot,k2 = num_fewshot2 , kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_cot')
class verbsingle_plusOne_com_incontext_cot(verbsingle_plusOne_com):
    def doc_to_target_rand(self, doc):
        inpp = doc['input'].split(' ')
        num = deterministic_random(doc['input'])
        inp = str(num + 1) + ' ' + inpp[-1]
        return inp
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text2(doc) + " -> " + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + " -> " + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_expcot')
class verbsingle_plusOne_com_incontext_expcot(verbsingle_plusOne_com):
    def doc_to_text1(self, doc):
        inp = f"step1: {doc['input']}\nstep2: "
        return inp
    def doc_to_target1(self, doc):
        return doc["output"]
    def doc_to_target1new(self, doc):
        return doc["output"]# + "\nstep3:"
    def doc_to_text2(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"input: {num}\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"{num}\nstep3:"
        return inp
    def doc_to_target2(self, doc):
        num = deterministic_random(doc['input'])
        return str(num + 1)
    def doc_to_text(self, doc):
        num = deterministic_random(doc['input'])
        inp = f"step1: {num} {doc['input']}\nstep2: "
        return inp
    def doc_to_target(self, doc):
        num = deterministic_random(doc['input'])
        oup =f"{num + 1} {doc['output']}"
        return oup
    def doc_to_target_rand(self, doc):
        inpp = doc['input'].split(' ')
        num = deterministic_random(doc['input'])
        inp = str(num) + ' ' + doc['output']
        return inp + "\nstep3:"
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + self.doc_to_target_rand(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        "step1:???\nstep2: " + self.doc_to_text2new(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1new(doc) + "\nstep3:???"
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            #print("fewshotex: ", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('verbsingle_plusOne_com_incontext_special')
class verbsingle_plusOne_com_incontext_special(verbsingle_plusOne_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        inpp = doc['input'].split(' ')
        num = deterministic_random(doc['input'])
        inp = str(num + 1) + ' ' + inpp[-1]
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        #rnd.shuffle(prompt_list)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example

@register('verbsingle_plusOne_com_incontext_special_shuffle')
class verbsingle_plusOne_com_incontext_special_shuffle(verbsingle_plusOne_com_incontext):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        inpp = doc['input'].split(' ')
        num = deterministic_random(doc['input'])
        inp = str(num + 1) + ' ' + inpp[-1]
        return inp
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        rnd.shuffle(prompt_list)
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n")
        aa = []
        for i in range(len(prompt_list)):
            aa.append(0)
        for i in range(len(prompt_list)):
            items = prompt_list[i]
            pr = items.split()
            if pr[1].isalpha():
                aa[i] = 1
            elif pr[1].isdigit() and pr[3].isdigit():
                aa[i] = 2
            else:
                aa[i] = 0
        example = self.doc_to_text(doc)
        prompt_listg = prompt_list.copy()
        prompt_listg.append(example)
        aa.append(3)
        return description + labeled_examples + example, prompt_listg, aa, example