import datasets
from .task import register, Task
from .verbsingle import verbsingle
import random

@register('oppoverb_oppo')
class oppoverb_oppo(verbsingle):
    train_files = './data/verb_oppo/oppo_verb_train.json'
    test_files =  './data/verb_oppo/oppo_verb_test.json'

    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: * {a}\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return a


@register('oppoverb_verb')
class oppoverb_verb(oppoverb_oppo):
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: # {b}\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return b

@register('oppoverb_com')
class oppoverb_com(oppoverb_oppo):
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: * {a}\noutput: "
        return inp
    def doc_to_target1(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return a
    def doc_to_targetcot1(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        doc["input"] = a
        return doc
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: # {b}\noutput: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"# {b}"
        return inp
    def doc_to_textcot2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        b = doc_to_target2(doc)
        inp = f"input: * {a} {b}\noutput: "
        return inp
    def doc_to_target2(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return b
    def doc_to_targetcot2(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        doc["input"] = b
        return doc
        
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: * {a} # {b}\noutput: "
        return inp
    
    def doc_to_target(self, doc):
        oup = doc['output']
        return oup
    def doc_to_textcot2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        b = self.doc_to_target2(doc)
        inp = f" * {a} {b} "
        return inp
    def doc_to_textcot1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        a = self.doc_to_target1(doc)
        inp = f" {a} # {b} "
        return inp


    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2=num_fewshot2, kc = 0, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example


@register('oppoverb_com_incontext')
class oppoverb_com_incontext(oppoverb_com):
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(doc)
        else:
            return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2=num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example

@register('oppoverb_com_incontext_tag')
class oppoverb_com_incontext_tag(oppoverb_com):
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(doc)
        else:
            return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2=num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        "(simple1)" + self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        "(simple2)" + self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        "(compose)" + self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = "(compose)" + self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_cot')
class oppoverb_com_incontext_cot(oppoverb_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(doc)
        else:
            return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2=num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        self.doc_to_text2(doc) + " -> " + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + " -> " + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_expcot')
class oppoverb_com_incontext_expcot(oppoverb_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_text1(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"step1: * {a}\nstep2: "
        return inp
    def doc_to_target1new(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return a# + "\nstep3:"
    def doc_to_target1(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return a
    def doc_to_text2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"step1: # {b}\nstep2: "
        return inp
    def doc_to_text2new(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"# {b}\nstep3:"
        return inp
    def doc_to_target2(self, doc):
        pair = doc['output'].split(" ")
        a, b = pair
        return b
    def doc_to_text(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"step1: * {a} # {b}\nstep2: "
        return inp
    def doc_to_target(self, doc):
        oup = doc['output']
        return oup
    def doc_to_textcot2(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        a = self.doc_to_target1(doc)
        inp = f"{a} # {b}\nstep3:"
        return inp
    def doc_to_target_rand(self, doc):
        return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == 0:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2=num_fewshot2, kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text(doc) + self.doc_to_target_rand(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ] + \
                    [
                        "step1:???\nstep2: " + self.doc_to_text2new(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text1(doc) + self.doc_to_target1new(doc) + "\nstep3:???"
                        for doc in fewshotex[:num_fewshot]
                    ]
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_re1')
class oppoverb_com_incontext_re1(oppoverb_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: + {a} % {b}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        oup = doc['input'].upper()
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_irrl_fixop')
class oppoverb_com_incontext_irrl_fixop(oppoverb_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: + {a} % {b}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        oup = doc['input'].upper()
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_irrl_fixcontent')
class oppoverb_com_incontext_irrl_fixcontent(oppoverb_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: + {a} % {b}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        oup = doc['input'].upper()
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text3(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text3(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_irrl')
class oppoverb_com_incontext_irrl(oppoverb_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: + {a} % {b}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        oup = doc['input'].upper()
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text3(doc) + self.doc_to_target3(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example
@register('oppoverb_com_incontext_special')
class oppoverb_com_incontext_special(oppoverb_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(doc)
        else:
            return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        #rnd.shuffle(prompt_list)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )
        labela = (
                "\n\n".join(
                    texta
                )+ "\n\n"
            )
        labelb = (
                "\n\n".join(
                    textb
                )+ "\n\n"
            )
        labelc = (
                "\n\n".join(
                    textc
                )+ "\n\n"
            )
        example = self.doc_to_text(doc)

        return description + labeled_examples + example, labela, labelb, labelc, example
@register('oppoverb_com_incontext_special_shuffle')
class oppoverb_com_incontext_special_shuffle(oppoverb_com):
    def doc_rand(self, doc):
        a = random.randint(4,7)
        b = ""
        for ii in range(a):
            d = random.randint(65, 90)
            e = random.randint(0, 1)
            d = chr(d)
            if e % 2 == 1:
                d = d.lower()
            b += d
        return b
    def doc_to_target_rand(self, doc):
        actt = random.randint(0, 2)
        if actt % 2 == 6:
            return self.doc_to_textcot1(doc)
        else:
            return self.doc_to_textcot2(doc)
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = ""
        fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2, kc = kc, rnd = rnd)
        textc = [self.doc_to_text(doc) + " -> " + self.doc_to_target_rand(doc) + " -> " + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]]
        texta = [self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]]
        textb = [self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]]
        prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
        rnd.shuffle(prompt_list)
            # print("fewshotex", fewshotex)
        labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n")
        aa = []
        for i in range(len(prompt_list)):
            aa.append(0)
        for i in range(len(prompt_list)):
            items = prompt_list[i]
            if ('*' in items) and ('#' in items):
                aa[i] = 0
            elif ('*' in items):
                aa[i] = 1
            else:
                aa[i] = 2
        #print(labeled_examples)
        #"input: Fail Enemy #\noutput: Enemy Fail\n\ninput: Ignore Junior #\noutput: Junior Ignore\n\ninput: Married Guilty #\noutput: Guilty Married\n\ninput: * Ordinary Harsh\noutput: Extraordinary Mild\n\ninput: * Eager Proud\noutput: Reluctant Humble\n\ninput: * Rich Humble\noutput: Poor Proud\n\ninput: Start Famous #\noutput: Famous Start\n\ninput: * Wide Light #\noutput: Dark Narrow\n\ninput: * Dry Lie\noutput: Wet Stand\n\ninput: * Glad Flat\noutput: Sad Hilly\n\ninput: * Regular Lose #\noutput: Win Irregular\n\ninput: * Front Happy #\noutput: Sad Back\n\ninput: * Divide Legal #\noutput: Illegal Unite\n\ninput: First Interest #\noutput: Interest First\n\ninput: * Far Land\noutput: Near Sea\n\ninput: * Sad Less\noutput: Happy More\n\ninput: Excited Day #\noutput: Day Excited\n\ninput: * Freeze Yes\noutput: Melt No\n\ninput: Miss Accept #\noutput: Accept Miss\n\ninput: * Black Expensive\noutput: White Cheap\n\ninput: Join Difficult #\noutput: Difficult Join\n\ninput: Regular Dirty #\noutput: Dirty Regular\n\ninput: * Intentional Divide #\noutput: Unite Accidental\n\ninput: Decrease Minor #\noutput: Minor Decrease\n\ninput: * Live Destroy\noutput: Die Build\n\n"
            

        example = self.doc_to_text(doc)
        prompt_listg = prompt_list.copy()
        prompt_listg.append(example)
        aa.append(3)
        return description + labeled_examples + example, prompt_listg, aa, example
@register('oppoverb_com_incontext_fix')
class oppoverb_com_incontext_fix(oppoverb_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        labeled_examples =  "* is a function before word for finding the opposite meaning of the word, # is another function before verb for finding the past tense of the verb\n\ninput: # involve\noutput: involved\n\ninput: * Descend # charge\noutput: Ascend charged\n\ninput: * Full # deserve\noutput: Empty deserved\n\ninput: * Borrow\noutput: Lend\n\ninput: * Enemy\noutput: Friend\n\ninput: * Rude\noutput: Polite\n\ninput: # ensure\noutput: ensured\n\ninput: * Optimist\noutput: Pessimist\n\ninput: # bake\noutput: baked\n\ninput: * Forget # deal\noutput: Remember dealt\n\ninput: * Accept\noutput: Reject\n\ninput: # hide\noutput: hid\n\ninput: # accept\noutput: accepted\n\ninput: # focus\noutput: focused\n\ninput: * Sad # read\noutput: Happy read\n\ninput: * Heavy\noutput: Light\n\ninput: # begin\noutput: began\n\ninput: # look\noutput: looked\n\ninput: # ask\noutput: asked\n\ninput: * Complicated\noutput: Simple\n\ninput: * Round\noutput: Square\n\ninput: * Interest\noutput: Disinterest\n\ninput: * Repair\noutput: Damage\n\ninput: * In # explain\noutput: Out explained\n\ninput: # cut\noutput: cut\n\n"

        example = self.doc_to_text(doc)

        return description + labeled_examples + example, description + labeled_examples
@register('oppoverb_com_incontext_fix_re1')
class oppoverb_com_incontext_fix_re1(oppoverb_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        labeled_examples =  "* is a function before word for finding the opposite meaning of the word, # is another function before verb for finding the past tense of the verb\n\ninput: # involve\noutput: involved\n\ninput: * Descend # charge\noutput: Ascend charged\n\ninput: * Full # deserve\noutput: Empty deserved\n\ninput: * Borrow\noutput: Lend\n\ninput: * Enemy\noutput: Friend\n\ninput: * Rude\noutput: Polite\n\ninput: # ensure\noutput: ensured\n\ninput: * Optimist\noutput: Pessimist\n\ninput: # bake\noutput: baked\n\ninput: * Forget # deal\noutput: Remember dealt\n\ninput: * Accept\noutput: Reject\n\ninput: # hide\noutput: hid\n\ninput: # accept\noutput: accepted\n\ninput: # focus\noutput: focused\n\ninput: * Sad # read\noutput: Happy read\n\ninput: * Heavy\noutput: Light\n\ninput: # begin\noutput: began\n\ninput: # look\noutput: looked\n\ninput: # ask\noutput: asked\n\ninput: * Complicated\noutput: Simple\n\ninput: * Round\noutput: Square\n\ninput: * Interest\noutput: Disinterest\n\ninput: * Repair\noutput: Damage\n\ninput: * In # explain\noutput: Out explained\n\ninput: # cut\noutput: cut\n\n"

        example = self.doc_to_text1(doc)

        return description + labeled_examples + example, description + labeled_examples
@register('oppoverb_com_incontext_fix_re2')
class oppoverb_com_incontext_fix_re2(oppoverb_com):
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2,rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        labeled_examples =  "* is a function before word for finding the opposite meaning of the word, # is another function before verb for finding the past tense of the verb\n\ninput: # involve\noutput: involved\n\ninput: * Descend # charge\noutput: Ascend charged\n\ninput: * Full # deserve\noutput: Empty deserved\n\ninput: * Borrow\noutput: Lend\n\ninput: * Enemy\noutput: Friend\n\ninput: * Rude\noutput: Polite\n\ninput: # ensure\noutput: ensured\n\ninput: * Optimist\noutput: Pessimist\n\ninput: # bake\noutput: baked\n\ninput: * Forget # deal\noutput: Remember dealt\n\ninput: * Accept\noutput: Reject\n\ninput: # hide\noutput: hid\n\ninput: # accept\noutput: accepted\n\ninput: # focus\noutput: focused\n\ninput: * Sad # read\noutput: Happy read\n\ninput: * Heavy\noutput: Light\n\ninput: # begin\noutput: began\n\ninput: # look\noutput: looked\n\ninput: # ask\noutput: asked\n\ninput: * Complicated\noutput: Simple\n\ninput: * Round\noutput: Square\n\ninput: * Interest\noutput: Disinterest\n\ninput: * Repair\noutput: Damage\n\ninput: * In # explain\noutput: Out explained\n\ninput: # cut\noutput: cut\n\n"

        example = self.doc_to_text2(doc)

        return description + labeled_examples + example, description + labeled_examples
#"* is a function before word for finding the opposite meaning of the word, # is another function before verb for finding the past tense of the verb\n\ninput: # involve\noutput: involved\n\ninput: * Descend # charge\noutput: Ascend charged\n\ninput: * Full # deserve\noutput: Empty deserved\n\ninput: * Borrow\noutput: Lend\n\ninput: * Enemy\noutput: Friend\n\ninput: * Rude\noutput: Polite\n\ninput: # ensure\noutput: ensured\n\ninput: * Optimist\noutput: Pessimist\n\ninput: # bake\noutput: baked\n\ninput: * Forget # deal\noutput: Remember dealt\n\ninput: * Accept\noutput: Reject\n\ninput: # hide\noutput: hid\n\ninput: # accept\noutput: accepted\n\ninput: # focus\noutput: focused\n\ninput: * Sad # read\noutput: Happy read\n\ninput: * Heavy\noutput: Light\n\ninput: # begin\noutput: began\n\ninput: # look\noutput: looked\n\ninput: # ask\noutput: asked\n\ninput: * Complicated\noutput: Simple\n\ninput: * Round\noutput: Square\n\ninput: * Interest\noutput: Disinterest\n\ninput: * Repair\noutput: Damage\n\ninput: * In # explain\noutput: Out explained\n\ninput: # cut\noutput: cut\n\n"
@register('oppoverb_com_incontext_distribution')
class oppoverb_com_incontext_distribution(oppoverb_com_incontext):
    def doc_to_text3(self, doc):
        pair = doc['input'].split(" ")
        a, b = pair
        inp = f"input: + {a} % {b}\noutput: "
        return inp
    
    def doc_to_target3(self, doc):
        oup = doc['input'].upper()
        return oup
    def fewshot_context(
        self, doc, kc, num_fewshot, num_fewshot2, rnd=None, description=None
    ):
        assert (
            rnd is not None
        ), "A `random.Random` generator argument must be provided to `rnd`"
        description = description + "\n\n" if description else ""
        
        if num_fewshot == -1:
            labeled_examples = ""
        else:
            fewshotex = self.fewshot_examples(k = num_fewshot, k2 = num_fewshot2,kc = kc, rnd = rnd)

            prompt_list = [
                        self.doc_to_text1(doc) + self.doc_to_target1(doc)
                        for doc in fewshotex[:num_fewshot]
                    ] + \
                    [
                        self.doc_to_text2(doc) + self.doc_to_target2(doc)
                        for doc in fewshotex[num_fewshot:num_fewshot+num_fewshot2]
                    ] + \
                    [
                        self.doc_to_text(doc) + self.doc_to_target(doc)
                        for doc in fewshotex[num_fewshot+num_fewshot2:]
                    ]
            
            rnd.shuffle(prompt_list)
            
            # print("fewshotex", fewshotex)
            labeled_examples = (
                "\n\n".join(
                    prompt_list
                )
                + "\n\n"
            )

        example = self.doc_to_text(doc)

        return description + labeled_examples + example