# Code for ICLR 2026 submission: C2Attack

## Installation

### Build environment via Anaconda

```
# create & activate conda environment
conda create -n concept-backdoor python=3.10
conda activate concept-backdoor

# install packages
conda install pytorch=2.4.0 torchvision=0.19.0 pytorch-cuda=11.8 -c pytorch -c nvidia
pip install transformers==4.44.2 datasets==3.0.0

# Additional packages for CLIP-Text-Span Experiments
pip install einops ftfy

```




## Compute Concept Scores
You need to follw the commands [here](https://github.com/dgcnz/FACT) to download the models and datasets.
Then you need to run the command below to learn the concepts.

```
#You should change the OUTPUT_DIR to your own direct to store the results.
python3 learn_concepts_dataset.py --dataset-name="broden" --backbone-name="clip:RN50" --C 0.001 0.01 0.1 1.0 10.0 --n-samples=50 --out-dir=$OUTPUT_DIR
```

Then, you need to run the command below to get the concept scores of different datasets.

```
python3 train_pcbm.py --concept-bank="${OUTPUT_DIR}/cub_resnet18_cub_0.1_100.pkl" --dataset="cifar10" --backbone-name="resnet18_cub" --out-dir=$OUTPUT_DIR --lam=2e-4
```
The concept scores are stored in numpy form in the directory of the $OUTPUT_DIR. 



## Clean Baseline
``` 
python clean_baseline.py \
    --dataset CIFAR-10 \
    --gpu 0 \
    --epochs 1 \
    --model_path openai/clip-vit-large-patch14 \
    --finetune_layers 9 \
    --learning_rate 1e-5
```


## Attack Baselines
```
python attack_baseline.py \
    --dataset CIFAR-10 \
    --gpu 0 \
    --epochs 1 \
    --model_path openai/clip-vit-large-patch14 \
    --finetune_layers 9 \
    --learning_rate 1e-5

```


## Concept Confusion Attack
```
python finetune_main.py

```





# Acknowledgement
Our code of calculating concept scores originated from the [code](https://github.com/dgcnz/FACT).
