import os
import json

from tqdm.auto import tqdm

from utils.func import read_jsonl
from dataset.base import BaseDataset

class RefCOCODataset(BaseDataset):
    def __init__(self, prompter, split="refcoco_val"):
        super(RefCOCODataset, self).__init__()
        with open(f"./data/coco/RefCOCO/OpenSource/finetune_{split}.json", 'r') as f:
            self.ann = json.load(f)
        self.img_root = f"./data/coco/train2014"        
        self.prompter = prompter
        self.split = split
         
    def get_data(self):
        data = []
        for item_img, item_ann in tqdm(zip(self.ann['images'], self.ann['annotations'])):
            img_height = item_img['height']
            img_width = item_img['width']
            caption = item_img['caption']
            target_bbox = item_ann["bbox"]
            converted_bbox = [
                target_bbox[0],
                target_bbox[1],
                target_bbox[2] + target_bbox[0],
                target_bbox[3] + target_bbox[1],
            ]
            
            data.append(
                {
                    "img_path": os.path.join(self.img_root, item_img['file_name']),
                    "question": self.prompter.build_prompt(item_img['caption']) + \
                                    f"The image size is (width, height) = ({img_width}, {img_height}).",
                    "img_width": img_width,
                    "img_height": img_height,
                    "label": converted_bbox
                }
            )
        return data, ["img_width", "img_height"]