MODEL_LIST = [
    # BLIP2
    {
        "model_name": "BLIP2",
        "model_path": "Salesforce/blip2-opt-2.7b",
        "store_model_path": "BLIP2-opt-2.7B",
    },
    {
        "model_name": "BLIP2",
        "model_path": "Salesforce/blip2-flan-t5-xxl",
        "store_model_path": "BLIP2-flan-t5-xxl",
    },
    {
        "model_name": "BLIP2",
        "model_path": "Salesforce/blip2-opt-6.7b-coco",
        "store_model_path": "BLIP2-opt-6.7b-coco",
    },
    {
        "model_name": "BLIP2",
        "model_path": "Salesforce/blip2-opt-6.7b",
        "store_model_path": "BLIP2-opt-6.7b",
    },
    {
        "model_name": "BLIP2",
        "model_path": "Salesforce/blip2-flan-t5-xl",
        "store_model_path": "BLIP2-flan-t5-xl",
    },


    # InstructBLIP
    ## Vicuna
    {
        "model_name": "InstructBLIP",
        "model_path": "Salesforce/instructblip-vicuna-7b",
        "store_model_path": "InstructBLIP-Vicuna-7B",
    },
    {
        "model_name": "InstructBLIP",
        "model_path": "Salesforce/instructblip-vicuna-13b",
        "store_model_path": "InstructBLIP-Vicuna-13B",
    },
    ## Flan-t5
    {
        "model_name": "InstructBLIP",
        "model_path": "Salesforce/instructblip-flan-t5-xl",
        "store_model_path": "InstructBLIP-flan-t5-xl",
    },
    {
        "model_name": "InstructBLIP",
        "model_path": "Salesforce/instructblip-flan-t5-xxl",
        "store_model_path": "InstructBLIP-flan-t5-xxl",
    },
    # MiniGPT4
    ## LLaMA2
    {
        "model_name": "MiniGPT4",
        "model_path": "./MiniGPT-4/eval_configs/minigpt4_llama2_eval.yaml",
        "store_model_path": "MiniGPT4-LLaMA2-7B",
    },
    ## Vicuna0
    {
        "model_name": "MiniGPT4",
        "model_path": "./MiniGPT-4/eval_configs/minigpt4_eval_7b.yaml",
        "store_model_path": "MiniGPT4-Vicuna0-7B",
    },
    {
        "model_name": "MiniGPT4",
        "model_path": "./MiniGPT-4/eval_configs/minigpt4_eval_13b.yaml",
        "store_model_path": "MiniGPT4-Vicuna0-13B",
    },

    # mPLUG_Owl
    {
        "model_name": "mPLUG-Owl",
        "model_path": "MAGAer13/mplug-owl2-llama2-7b",
        "store_model_path": "mPLUG-Owl2-LLaMA2-7B",
    },
    {
        "model_name": "mPLUG-Owl",
        "model_path": "Mizukiluke/mplug_owl_2_1",
        "store_model_path": "mPLUG-Owl2_1",
    },

    # LLaVA
    # I really love LLaVA
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.5-7b",
        "store_model_path": "LLaVA-7B",
    },
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.5-13b",
        "store_model_path": "LLaVA-13B",
    },
    # LLaVA-Next
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.6-vicuna-7b",
        "store_model_path": "LLaVA-v1.6-Vicuna-7B",
    },
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.6-vicuna-13b",
        "store_model_path": "LLaVA-v1.6-Vicuna-13B",
    },
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.6-mistral-7b",
        "store_model_path": "LLaVA-v1.6-Mistral-7B",
    },
    {
        "model_name": "LLaVA",
        "model_path": "liuhaotian/llava-v1.6-34b",
        "store_model_path": "LLaVA-v1.6-34B",
    },
    # Cambrian
    {
        "model_name": "Cambrian",
        "model_path": "nyu-visionx/cambrian-phi3-3b",
        "store_model_path": "Cambrian-Phi3-3B",
    },
    {
        "model_name": "Cambrian",
        "model_path": "nyu-visionx/cambrian-8b",
        "store_model_path": "Cambrian-8B",
    },
    {
        "model_name": "Cambrian",
        "model_path": "nyu-visionx/cambrian-13b",
        "store_model_path": "Cambrian-13B",
    },
    {
        "model_name": "Cambrian",
        "model_path": "nyu-visionx/cambrian-34b",
        "store_model_path": "Cambrian-34B",
    },

    # Fuyu-8B
    {
        "model_name": "Fuyu",
        "model_path": "adept/fuyu-8b",
        "store_model_path": "Fuyu-8B",
    },

    # LLaMA-Adapter-V2
    {
        "model_name": "LLaMA_Adapter",
        "model_path": "BIAS-7B",
        "store_model_path": "LLaMA-Adapter-V2-BIAS-7B",
    },
    {
        "model_name": "LLaMA_Adapter",
        "model_path": "LORA-BIAS-7B",
        "store_model_path": "LLaMA-Adapter-V2-LORA-BIAS-7B",
    },
    {
        "model_name": "LLaMA_Adapter",
        "model_path": "LORA-BIAS-7B-v21",
        "store_model_path": "LLaMA-Adapter-V2-LORA-BIAS-7B-v21",
    },

    # # Kosmos-2
    # {
    #     "model_name": "Kosmos2",
    #     "model_path": "ydshieh/kosmos-2-patch14-224",
    #     "store_model_path": "Kosmos-2",
    # },

    # # OpenFlamingo
    {
        "model_name": "OpenFlamingo",
        "model_path": "openflamingo/OpenFlamingo-3B-vitl-mpt1b",
        "store_model_path": "OpenFlamingo-3B-vitl-mpt1b",
    },
    {
        "model_name": "OpenFlamingo",
        "model_path": "openflamingo/OpenFlamingo-3B-vitl-mpt1b-langinstruct",
        "store_model_path": "OpenFlamingo-3B-vitl-mpt1b-langinstruct",
    },
    {
        "model_name": "OpenFlamingo",
        "model_path": "openflamingo/OpenFlamingo-4B-vitl-rpj3b",
        "store_model_path": "OpenFlamingo-4B-vitl-rpj3b",
    },
    {
        "model_name": "OpenFlamingo",
        "model_path": "openflamingo/OpenFlamingo-4B-vitl-rpj3b-langinstruct",
        "store_model_path": "OpenFlamingo-4B-vitl-rpj3b-langinstruct",
    },
    {
        "model_name": "OpenFlamingo",
        "model_path": "openflamingo/OpenFlamingo-9B-vitl-mpt7b",
        "store_model_path": "OpenFlamingo-9B-vitl-mpt7b",
    },

    # Qwen-VL
    {
        "model_name": "Qwen-VL",
        "model_path": "Qwen/Qwen-VL-Chat",
        "store_model_path": "Qwen-VL-Chat",
    },
    # No reasonable results
    # {
    #     "model_name": "Qwen-VL",
    #     "model_path": "Qwen/Qwen-VL-Chat-Int4",
    #     "store_model_path": "Qwen-VL-Chat-Int4",
    # },

    # InternLM_XComposer
    {
        "model_name": "InternLM_XComposer",
        "model_path": "internlm/internlm-xcomposer-7b",
        "store_model_path": "InternLM-XComposer-7B",
    },
    {
        "model_name": "InternLM_XComposer",
        "model_path": "internlm/internlm-xcomposer-vl-7b",
        "store_model_path": "InternLM-XComposer-vl-7B",
    },
    {
        "model_name": "InternLM_XComposer",
        "model_path": "internlm/internlm-xcomposer2-7b",
        "store_model_path": "InternLM-XComposer2-7B",
    },
    {
        "model_name": "InternLM_XComposer",
        "model_path": "internlm/internlm-xcomposer2-vl-1_8b",
        "store_model_path": "InternLM-XComposer2-vl-1_8b",
    },
    {
        "model_name": "InternLM_XComposer",
        "model_path": "internlm/internlm-xcomposer2-vl-7b",
        "store_model_path": "InternLM-XComposer2-vl-7B",
    },
    # {
    #     "model_name": "InternLM_XComposer",
    #     "model_path": "internlm/internlm-xcomposer2-4khd-7b",
    #     "store_model_path": "InternLM-XComposer2-4khd-7B",
    # },
    # {
    #     "model_name": "InternLM_XComposer",
    #     "model_path": "internlm/internlm-xcomposer2d5-clip",
    #     "store_model_path": "InternLM-XComposer2d5-clip",
    # },
    # {
    #     "model_name": "InternLM_XComposer",
    #     "model_path": "internlm/internlm-xcomposer2d5-7b",
    #     "store_model_path": "InternLM-XComposer2d5-7B",
    # },


    # OpenAI
    {
        "model_name": "GPT4",
        "model_path": "gpt-4o-2024-05-13",
        "store_model_path": "gpt-4o-2024-05-13",
    },
    {
        "model_name": "GPT4",
        "model_path": "gpt-4o-2024-08-06",
        "store_model_path": "gpt-4o-2024-08-06",
    },
    {
        "model_name": "GPT4",
        "model_path": "gpt-4o-mini-2024-07-18",
        "store_model_path": "gpt-4o-mini-2024-07-18",
    },
    {
        "model_name": "GPT4",
        "model_path": "gpt-4-turbo-2024-04-09",
        "store_model_path": "gpt-4-turbo-2024-04-09",
    },

    # Gemini
    {
        "model_name": "Gemini",
        "model_path": "gemini-1.5-pro",
        "store_model_path": "gemini-1.5-pro",
    },
    {
        "model_name": "Gemini",
        "model_path": "gemini-1.5-flash",
        "store_model_path": "gemini-1.5-flash",
    },

    # PrismaticVLMs
    {'model_name': 'prismatic',
    'model_path': 'reproduction-llava-v15+7b',
    'store_model_path': 'reproduction-llava-v15+7b'},
    {'model_name': 'prismatic',
    'model_path': 'reproduction-llava-v15+13b',
    'store_model_path': 'reproduction-llava-v15+13b'},
    {'model_name': 'prismatic',
    'model_path': 'one-stage+7b',
    'store_model_path': 'one-stage+7b'},
    {'model_name': 'prismatic',
    'model_path': 'one-stage+13b',
    'store_model_path': 'one-stage+13b'},
    {'model_name': 'prismatic',
    'model_path': 'full-ft-multi-stage+7b',
    'store_model_path': 'full-ft-multi-stage+7b'},
    {'model_name': 'prismatic',
    'model_path': 'full-ft-one-stage+7b',
    'store_model_path': 'full-ft-one-stage+7b'},
    {'model_name': 'prismatic',
    'model_path': 'in1k-224px+7b',
    'store_model_path': 'in1k-224px+7b'},
    {'model_name': 'prismatic',
    'model_path': 'dinov2-224px+7b',
    'store_model_path': 'dinov2-224px+7b'},
    {'model_name': 'prismatic',
    'model_path': 'clip-224px+7b',
    'store_model_path': 'clip-224px+7b'},
    {'model_name': 'prismatic',
    'model_path': 'siglip-224px+7b',
    'store_model_path': 'siglip-224px+7b'},
    {'model_name': 'prismatic',
    'model_path': 'clip-336px-resize-crop+7b',
    'store_model_path': 'clip-336px-resize-crop+7b'},
    {'model_name': 'prismatic',
    'model_path': 'clip-336px-resize-naive+7b',
    'store_model_path': 'clip-336px-resize-naive+7b'},
    {'model_name': 'prismatic',
    'model_path': 'siglip-384px-letterbox+7b',
    'store_model_path': 'siglip-384px-letterbox+7b'},
    {'model_name': 'prismatic',
    'model_path': 'siglip-384px-resize-crop+7b',
    'store_model_path': 'siglip-384px-resize-crop+7b'},
    {'model_name': 'prismatic',
    'model_path': 'siglip-384px-resize-naive+7b',
    'store_model_path': 'siglip-384px-resize-naive+7b'},
    {'model_name': 'prismatic',
    'model_path': 'dinoclip-336px-letterbox+7b',
    'store_model_path': 'dinoclip-336px-letterbox+7b'},
    {'model_name': 'prismatic',
    'model_path': 'dinoclip-336px-resize-naive+7b',
    'store_model_path': 'dinoclip-336px-resize-naive+7b'},
    {'model_name': 'prismatic',
    'model_path': 'dinosiglip-384px-letterbox+7b',
    'store_model_path': 'dinosiglip-384px-letterbox+7b'},
    {'model_name': 'prismatic',
    'model_path': 'dinosiglip-384px-resize-naive+7b',
    'store_model_path': 'dinosiglip-384px-resize-naive+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llama2+7b',
    'store_model_path': 'llama2+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llama2+13b',
    'store_model_path': 'llama2+13b'},
    {'model_name': 'prismatic',
    'model_path': 'vicuna-no-cotraining+7b',
    'store_model_path': 'vicuna-no-cotraining+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llama2-no-cotraining+7b',
    'store_model_path': 'llama2-no-cotraining+7b'},
    {'model_name': 'prismatic',
    'model_path': 'train-1.25-epochs+7b',
    'store_model_path': 'train-1.25-epochs+7b'},
    {'model_name': 'prismatic',
    'model_path': 'train-1.5-epochs+7b',
    'store_model_path': 'train-1.5-epochs+7b'},
    {'model_name': 'prismatic',
    'model_path': 'train-2-epochs+7b',
    'store_model_path': 'train-2-epochs+7b'},
    {'model_name': 'prismatic',
    'model_path': 'train-3-epochs+7b',
    'store_model_path': 'train-3-epochs+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llava-lvis4v+7b',
    'store_model_path': 'llava-lvis4v+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llava-lrv+7b',
    'store_model_path': 'llava-lrv+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llava-lvis4v-lrv+7b',
    'store_model_path': 'llava-lvis4v-lrv+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-clip-controlled+7b',
    'store_model_path': 'prism-clip-controlled+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-clip-controlled+13b',
    'store_model_path': 'prism-clip-controlled+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-clip+7b',
    'store_model_path': 'prism-clip+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-clip+13b',
    'store_model_path': 'prism-clip+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-siglip-controlled+7b',
    'store_model_path': 'prism-siglip-controlled+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-siglip-controlled+13b',
    'store_model_path': 'prism-siglip-controlled+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-siglip+7b',
    'store_model_path': 'prism-siglip+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-siglip+13b',
    'store_model_path': 'prism-siglip+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip-controlled+7b',
    'store_model_path': 'prism-dinosiglip-controlled+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip-controlled+13b',
    'store_model_path': 'prism-dinosiglip-controlled+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip+7b',
    'store_model_path': 'prism-dinosiglip+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip+13b',
    'store_model_path': 'prism-dinosiglip+13b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip-224px-controlled+7b',
    'store_model_path': 'prism-dinosiglip-224px-controlled+7b'},
    {'model_name': 'prismatic',
    'model_path': 'prism-dinosiglip-224px+7b',
    'store_model_path': 'prism-dinosiglip-224px+7b'},
    {'model_name': 'prismatic',
    'model_path': 'llama2-chat+13b',
    'store_model_path': 'llama2-chat+13b'},
    {'model_name': 'prismatic',
    'model_path': 'mistral-v0.1+7b',
    'store_model_path': 'mistral-v0.1+7b'},
    {'model_name': 'prismatic',
    'model_path': 'mistral-instruct-v0.1+7b',
    'store_model_path': 'mistral-instruct-v0.1+7b'},
    {'model_name': 'prismatic',
    'model_path': 'phi-2+3b',
    'store_model_path': 'phi-2+3b'},
    {
    'model_name': 'prismatic',
    'model_path': './prismatic-vlms/gemma-instruct+2b+clip/',
    'store_model_path': 'gemma-instruct+2b+clip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/gemma-instruct+2b+siglip/',
        'store_model_path': 'gemma-instruct+2b+siglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/gemma-instruct+2b+dinosiglip/',
        'store_model_path': 'gemma-instruct+2b+dinosiglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/gemma-instruct+8b+clip/',
        'store_model_path': 'gemma-instruct+8b+clip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/gemma-instruct+8b+siglip/',
        'store_model_path': 'gemma-instruct+8b+siglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/gemma-instruct+8b+dinosiglip/',
        'store_model_path': 'gemma-instruct+8b+dinosiglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama2-chat+7b+clip/',
        'store_model_path': 'llama2-chat+7b+clip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama2-chat+7b+siglip/',
        'store_model_path': 'llama2-chat+7b+siglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama2-chat+7b+dinosiglip/',
        'store_model_path': 'llama2-chat+7b+dinosiglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama3-instruct+8b+clip/',
        'store_model_path': 'llama3-instruct+8b+clip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama3-instruct+8b+siglip/',
        'store_model_path': 'llama3-instruct+8b+siglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/llama3-instruct+8b+dinosiglip/',
        'store_model_path': 'llama3-instruct+8b+dinosiglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/mistral-instruct-v0.2+7b+clip/',
        'store_model_path': 'mistral-instruct-v0.2+7b+clip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/mistral-instruct-v0.2+7b+siglip/',
        'store_model_path': 'mistral-instruct-v0.2+7b+siglip'
    },
    {
        'model_name': 'prismatic',
        'model_path': './prismatic-vlms/mistral-instruct-v0.2+7b+dinosiglip/',
        'store_model_path': 'mistral-instruct-v0.2+7b+dinosiglip'
    },
]

TASK_INFO = [
    {
        "dataset": "SEED_2",
        "num_tasks": 27,
        "num_samples": 24371,
        "sub_sampling": None,
        "evaluation": "avg"
    }, 
    {
        "dataset": "MME",
        "num_tasks": 14,
        "num_samples": 2374,
        "sub_sampling": None,
        "evaluation": "true_false"
    },
    {
        "dataset": "MMBench_CN",
        "num_tasks": 20,
        "num_samples": 4329,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {
        "dataset": "MMBench_EN",
        "num_tasks": 20,
        "num_samples": 4329,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {
        "dataset": "MMMU",
        "num_tasks": 30,
        "num_samples": 900,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {
        "dataset": "CMMMU",
        "num_tasks": 6,
        "num_samples": 900,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {
        "dataset": "ScienceQA",
        "num_tasks": 25,
        "num_samples": 2017,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {
        "dataset": "CVBench",
        "num_tasks": 4,
        "num_samples": 2638,
        "sub_sampling": None,
        "evaluation": "avg"
    },
    {'dataset': 'DECIMER',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Enrico',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'FaceEmotion',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Flickr30k',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'GQA', 'num_tasks': 1, 'num_samples': 100, 'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'HatefulMemes',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'INAT',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'IRFL',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'MemeCaps',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Memotion',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'MMIMDB',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'NewYorkerCartoon',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'NLVR',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'NLVR2',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'NoCaps',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'OKVQA',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'OpenPath',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'PathVQA',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Resisc45',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Screen2Words',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Slake',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'UCMerced',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'VCR', 'num_tasks': 1, 'num_samples': 100, 'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'VisualGenome',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'VQA', 'num_tasks': 1, 'num_samples': 100, 'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'VQARAD',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {'dataset': 'Winoground',
    'num_tasks': 1,
    'num_samples': 100,
    'sub_sampling': 100,
        "evaluation": "hemm"},
    {
        'dataset': 'POPE',
    'num_tasks': 3,
    'num_samples': 900,
    'sub_sampling': 900,
        "evaluation": "true_false"
    },
]

ALL_DATASETS = [
    'Instance Attributes (SEED_2)',
    'Emotion Recognition (SEED_2)',
    'Global Video Understanding (SEED_2)',
    'Chart Understanding (SEED_2)',
    'Landmark Recognition (SEED_2)',
    'Instances Counting (SEED_2)',
    'Action Prediction (SEED_2)',
    'Text Understanding (SEED_2)',
    'Text-to-Image Generation (SEED_2)',
    'Action Recognition (SEED_2)',
    'Instance Location (SEED_2)',
    'Instance Interaction (SEED_2)',
    'Scene Understanding (SEED_2)',
    'Instance Identity (SEED_2)',
    'Text-Image Creation (SEED_2)',
    'Visual Mathematics (SEED_2)',
    'Difference Spotting (SEED_2)',
    'Spatial Relation (SEED_2)',
    'Science Knowledge (SEED_2)',
    'Procedure Understanding (SEED_2)',
    'Visual Reasoning (SEED_2)',
    'In-Context Captioning (SEED_2)',
    'Meme Comprehension (SEED_2)',
    'Celebrity Recognition (SEED_2)',
    'Visual Referring Expression (SEED_2)',
    'Interleaved Image-Text Analysis (SEED_2)',
    'Next Image Prediction (SEED_2)',
    'celebrity (MME)',
    'posters (MME)',
    'position (MME)',
    'scene (MME)',
    'commonsense_reasoning (MME)',
    'artwork (MME)',
    'landmark (MME)',
    'text_translation (MME)',
    'existence (MME)',
    'numerical_calculation (MME)',
    'count (MME)',
    'color (MME)',
    'OCR (MME)',
    'code_reasoning (MME)',
    'social_relation (MMBench_CN)',
    'object_localization (MMBench_CN)',
    'future_prediction (MMBench_CN)',
    'physical_property_reasoning (MMBench_CN)',
    'attribute_comparison (MMBench_CN)',
    'nature_relation (MMBench_CN)',
    'action_recognition (MMBench_CN)',
    'image_scene (MMBench_CN)',
    'celebrity_recognition (MMBench_CN)',
    'ocr (MMBench_CN)',
    'spatial_relationship (MMBench_CN)',
    'structuralized_imagetext_understanding (MMBench_CN)',
    'image_emotion (MMBench_CN)',
    'function_reasoning (MMBench_CN)',
    'identity_reasoning (MMBench_CN)',
    'physical_relation (MMBench_CN)',
    'image_style (MMBench_CN)',
    'attribute_recognition (MMBench_CN)',
    'image_quality (MMBench_CN)',
    'image_topic (MMBench_CN)',
    'social_relation (MMBench_EN)',
    'object_localization (MMBench_EN)',
    'future_prediction (MMBench_EN)',
    'physical_property_reasoning (MMBench_EN)',
    'attribute_comparison (MMBench_EN)',
    'nature_relation (MMBench_EN)',
    'action_recognition (MMBench_EN)',
    'image_scene (MMBench_EN)',
    'celebrity_recognition (MMBench_EN)',
    'ocr (MMBench_EN)',
    'spatial_relationship (MMBench_EN)',
    'structuralized_imagetext_understanding (MMBench_EN)',
    'image_emotion (MMBench_EN)',
    'function_reasoning (MMBench_EN)',
    'identity_reasoning (MMBench_EN)',
    'physical_relation (MMBench_EN)',
    'image_style (MMBench_EN)',
    'attribute_recognition (MMBench_EN)',
    'image_quality (MMBench_EN)',
    'image_topic (MMBench_EN)',
    'Mechanical_Engineering (MMMU)',
    'Basic_Medical_Science (MMMU)',
    'Math (MMMU)',
    'Pharmacy (MMMU)',
    'Public_Health (MMMU)',
    'Physics (MMMU)',
    'Energy_and_Power (MMMU)',
    'Sociology (MMMU)',
    'Art_Theory (MMMU)',
    'History (MMMU)',
    'Materials (MMMU)',
    'Geography (MMMU)',
    'Chemistry (MMMU)',
    'Electronics (MMMU)',
    'Economics (MMMU)',
    'Art (MMMU)',
    'Accounting (MMMU)',
    'Psychology (MMMU)',
    'Architecture_and_Engineering (MMMU)',
    'Manage (MMMU)',
    'Clinical_Medicine (MMMU)',
    'Music (MMMU)',
    'Finance (MMMU)',
    'Marketing (MMMU)',
    'Design (MMMU)',
    'Literature (MMMU)',
    'Biology (MMMU)',
    'Diagnostics_and_Laboratory_Medicine (MMMU)',
    'Computer_Science (MMMU)',
    'Agriculture (MMMU)',
    '技术与工程 (CMMMU)',
    '商业 (CMMMU)',
    '健康与医学 (CMMMU)',
    '人文社会科学 (CMMMU)',
    '科学 (CMMMU)',
    '艺术与设计 (CMMMU)',
    'Ecosystems (ScienceQA)',
    'English colonies in North America (ScienceQA)',
    'State capitals (ScienceQA)',
    'Designing experiments (ScienceQA)',
    'Materials (ScienceQA)',
    'Adaptations (ScienceQA)',
    'Velocity, acceleration, and forces (ScienceQA)',
    'Particle motion and energy (ScienceQA)',
    'Geography (ScienceQA)',
    'Magnets (ScienceQA)',
    'Astronomy (ScienceQA)',
    'Oceania: geography (ScienceQA)',
    'Weather and climate (ScienceQA)',
    'The Americas: geography (ScienceQA)',
    'Classification and scientific names (ScienceQA)',
    'Engineering practices (ScienceQA)',
    'Atoms and molecules (ScienceQA)',
    'Scientific names (ScienceQA)',
    'Solutions (ScienceQA)',
    'Maps (ScienceQA)',
    'Genes to traits (ScienceQA)',
    'Physical Geography (ScienceQA)',
    'Classification (ScienceQA)',
    'Basic economic principles (ScienceQA)',
    'Colonial America (ScienceQA)',
    '2D Count (CVBench)',
    '3D Distance (CVBench)',
    '2D Relation (CVBench)',
    '3D Depth (CVBench)',
    'Whole dataset (DECIMER)',
    'Whole dataset (Enrico)',
    'Whole dataset (FaceEmotion)',
    'Whole dataset (Flickr30k)',
    'Whole dataset (GQA)',
    'Whole dataset (HatefulMemes)',
    'Whole dataset (INAT)',
    'Whole dataset (IRFL)',
    'Whole dataset (MemeCaps)',
    'Whole dataset (Memotion)',
    'Whole dataset (MMIMDB)',
    'Whole dataset (NewYorkerCartoon)',
    'Whole dataset (NLVR)',
    'Whole dataset (NLVR2)',
    'Whole dataset (NoCaps)',
    'Whole dataset (OKVQA)',
    'Whole dataset (OpenPath)',
    'Whole dataset (PathVQA)',
    'Whole dataset (Resisc45)',
    'Whole dataset (Screen2Words)',
    'Whole dataset (Slake)',
    'Whole dataset (UCMerced)',
    'Whole dataset (VCR)',
    'Whole dataset (VisualGenome)',
    'Whole dataset (VQA)',
    'Whole dataset (VQARAD)',
    'Whole dataset (Winoground)',
    'random (POPE)',
    'popular (POPE)',
    'adversarial (POPE)'
]

ALL_DATASET_NAMES = [
    'Instance Attributes (SEED_2)',
    'Emotion Recognition (SEED_2)',
    'Global Video Understanding (SEED_2)',
    'Chart Understanding (SEED_2)',
    'Landmark Recognition (SEED_2)',
    'Instances Counting (SEED_2)',
    'Action Prediction (SEED_2)',
    'Text Understanding (SEED_2)',
    'Text-to-Image Generation (SEED_2)',
    'Action Recognition (SEED_2)',
    'Instance Location (SEED_2)',
    'Instance Interaction (SEED_2)',
    'Scene Understanding (SEED_2)',
    'Instance Identity (SEED_2)',
    'Text-Image Creation (SEED_2)',
    'Visual Mathematics (SEED_2)',
    'Difference Spotting (SEED_2)',
    'Spatial Relation (SEED_2)',
    'Science Knowledge (SEED_2)',
    'Procedure Understanding (SEED_2)',
    'Visual Reasoning (SEED_2)',
    'In-Context Captioning (SEED_2)',
    'Meme Comprehension (SEED_2)',
    'Celebrity Recognition (SEED_2)',
    'Visual Referring Expression (SEED_2)',
    'Interleaved Image-Text Analysis (SEED_2)',
    'Next Image Prediction (SEED_2)',
    'Celebrity (MME)',
    'Posters (MME)',
    'Position (MME)',
    'Scene (MME)',
    'Commonsense Reasoning (MME)',
    'Artwork (MME)',
    'Landmark (MME)',
    'Text Translation (MME)',
    'Existence (MME)',
    'Numerical Calculation (MME)',
    'Count (MME)',
    'Color (MME)',
    'OCR (MME)',
    'Code Reasoning (MME)',
    'Social Relation (MMBench_CN)',
    'Object Localization (MMBench_CN)',
    'Future Prediction (MMBench_CN)',
    'Physical Property Reasoning (MMBench_CN)',
    'Attribute Comparison (MMBench_CN)',
    'Nature Relation (MMBench_CN)',
    'Action Recognition (MMBench_CN)',
    'Image Scene (MMBench_CN)',
    'Celebrity Recognition (MMBench_CN)',
    'OCR (MMBench_CN)',
    'Spatial Relationship (MMBench_CN)',
    'Structuralized Image-Text Understanding (MMBench_CN)',
    'Image Emotion (MMBench_CN)',
    'Function Reasoning (MMBench_CN)',
    'Identity Reasoning (MMBench_CN)',
    'Physical Relation (MMBench_CN)',
    'Image Style (MMBench_CN)',
    'Attribute Recognition (MMBench_CN)',
    'Image Quality (MMBench_CN)',
    'Image Topic (MMBench_CN)',
    'Social Relation (MMBench_EN)',
    'Object Localization (MMBench_EN)',
    'Future Prediction (MMBench_EN)',
    'Physical Property Reasoning (MMBench_EN)',
    'Attribute Comparison (MMBench_EN)',
    'Nature Relation (MMBench_EN)',
    'Action Recognition (MMBench_EN)',
    'Image Scene (MMBench_EN)',
    'Celebrity Recognition (MMBench_EN)',
    'OCR (MMBench_EN)',
    'Spatial Relationship (MMBench_EN)',
    'Structuralized Image-Text Understanding (MMBench_EN)',
    'Image Emotion (MMBench_EN)',
    'Function Reasoning (MMBench_EN)',
    'Identity Reasoning (MMBench_EN)',
    'Physical Relation (MMBench_EN)',
    'Image Style (MMBench_EN)',
    'Attribute Recognition (MMBench_EN)',
    'Image Quality (MMBench_EN)',
    'Image Topic (MMBench_EN)',
    'Mechanical Engineering (MMMU)',
    'Basic Medical Science (MMMU)',
    'Math (MMMU)',
    'Pharmacy (MMMU)',
    'Public Health (MMMU)',
    'Physics (MMMU)',
    'Energy and Power (MMMU)',
    'Sociology (MMMU)',
    'Art Theory (MMMU)',
    'History (MMMU)',
    'Materials (MMMU)',
    'Geography (MMMU)',
    'Chemistry (MMMU)',
    'Electronics (MMMU)',
    'Economics (MMMU)',
    'Art (MMMU)',
    'Accounting (MMMU)',
    'Psychology (MMMU)',
    'Architecture and Engineering (MMMU)',
    'Manage (MMMU)',
    'Clinical Medicine (MMMU)',
    'Music (MMMU)',
    'Finance (MMMU)',
    'Marketing (MMMU)',
    'Design (MMMU)',
    'Literature (MMMU)',
    'Biology (MMMU)',
    'Diagnostics and Laboratory Medicine (MMMU)',
    'Computer Science (MMMU)',
    'Agriculture (MMMU)',
    'Technology and Engineering (CMMMU)',
    'Business (CMMMU)',
    'Health and Medicine (CMMMU)',
    'Humanities and Social Sciences (CMMMU)',
    'Science (CMMMU)',
    'Arts and Design (CMMMU)',
    'Ecosystems (ScienceQA)',
    'English Colonies in North America (ScienceQA)',
    'State Capitals (ScienceQA)',
    'Designing Experiments (ScienceQA)',
    'Materials (ScienceQA)',
    'Adaptations (ScienceQA)',
    'Velocity, Acceleration, and Forces (ScienceQA)',
    'Particle Motion and Energy (ScienceQA)',
    'Geography (ScienceQA)',
    'Magnets (ScienceQA)',
    'Astronomy (ScienceQA)',
    'Oceania: Geography (ScienceQA)',
    'Weather and Climate (ScienceQA)',
    'The Americas: Geography (ScienceQA)',
    'Classification and Scientific Names (ScienceQA)',
    'Engineering Practices (ScienceQA)',
    'Atoms and Molecules (ScienceQA)',
    'Scientific Names (ScienceQA)',
    'Solutions (ScienceQA)',
    'Maps (ScienceQA)',
    'Genes to Traits (ScienceQA)',
    'Physical Geography (ScienceQA)',
    'Classification (ScienceQA)',
    'Basic Economic Principles (ScienceQA)',
    'Colonial America (ScienceQA)',
    '2D Count (CVBench)',
    '3D Distance (CVBench)',
    '2D Relation (CVBench)',
    '3D Depth (CVBench)',
    'DECIMER',
    'Enrico',
    'FaceEmotion',
    'Flickr30k',
    'GQA',
    'HatefulMemes',
    'INAT',
    'IRFL',
    'MemeCaps',
    'Memotion',
    'MMIMDB',
    'NewYorkerCartoon',
    'NLVR',
    'NLVR2',
    'NoCaps',
    'OKVQA',
    'OpenPath',
    'PathVQA',
    'Resisc45',
    'Screen2Words',
    'Slake',
    'UCMerced',
    'VCR',
    'VisualGenome',
    'VQA',
    'VQARAD',
    'Winoground',
    'Random (POPE)',
    'Popular (POPE)',
    'Adversarial (POPE)'
]