#!/bin/bash

set -e

PROJECT_ROOT="$(cd "$(dirname "$0")/.." && pwd)"
LOG_DIR="$PROJECT_ROOT/logs/solar"
DATA_ROOT="$PROJECT_ROOT/datasets/solar"

mkdir -p "$LOG_DIR"

export CUDA_VISIBLE_DEVICES=0

SEQ_LEN=96
MODEL_NAME=FACT

PRED_LENS="96"

echo "Running FACT Solar experiments"
for PRED_LEN in $PRED_LENS; do
  echo "--> seq_len=${SEQ_LEN}, pred_len=${PRED_LEN}"
  (
    cd "$PROJECT_ROOT" && \
    python run.py \
      --is_training 1 \
      --data Solar \
      --root_path "$DATA_ROOT" \
      --data_path solar_AL.txt \
      --model_id Solar_${SEQ_LEN}_${PRED_LEN} \
      --model ${MODEL_NAME} \
      --features M \
      --freq t \
      --target OT \
      --seq_len ${SEQ_LEN} \
      --pred_len ${PRED_LEN} \
      --e_layers 2 \
      --enc_in 137 \
      --dec_in 137 \
      --c_out 137 \
      --d_model 128 \
      --learning_rate 0.0005 \
      --batch_size 32 \
      --train_epochs 10 \
      --patience 3 \
      --use_dynfbd true \
      --dynfbd_variant gauss \
      --use_fselector true \
      --target_unit_k 128 \
      --lambda_coh 0.01 \
      --lambda_phase 0.01 \
      --encoder_type transformer \
      --use_guided_gating true \
      --use_channel_mixing true \
      --use_adaptive_fusion true \
      --use_revin true \
      --des Exp \
      --itr 1 \
      --checkpoints "$PROJECT_ROOT/checkpoints" \
      --num_workers 4
  ) | tee "$LOG_DIR/${MODEL_NAME}_Solar_${SEQ_LEN}_${PRED_LEN}.log"
done

echo "All runs completed. Logs saved to $LOG_DIR"
