import numpy as np


def legendre2(coefs,x):
    return np.polynomial.legendre.legval(x, coefs)


def setupInverseFFTCorrectionFactor(numberOfSamplingPoints):
    coefficients = np.array([0.5767616E+02, 0.0, -0.8931343E+02, 0.0, 0.4167596E+02, 0.0, -0.1053599E+02, 0.0, 0.1662374E+01, 0.0, -0.1780527E-00, 0.0, 0.1372983E-01, 0.0, -0.7963169E-03, 0.0, 0.3593372E-04, 0.0, -0.1295941E-05, 0.0, 0.3817796E-07])
    lookupTableOfConvolventInFourierSpace = legendre2(coefficients, np.arange(numberOfSamplingPoints)/float(numberOfSamplingPoints) )/legendre2(coefficients, 0.)
    #due to rounding effects we may be beond the size of the convolvent, so we zero pad to avoid seg-fault
    lookupTableOfConvolventInFourierSpace = np.lib.pad(lookupTableOfConvolventInFourierSpace, (0,numberOfSamplingPoints), 'constant', constant_values=(0.0, 0.0)).astype(np.float32)
    def convolvent(x):
        return lookupTableOfConvolventInFourierSpace[np.round(x).astype(np.int32)]
    lmbda = 0.99998546
    scaleRatio = float(numberOfSamplingPoints)/float(numberOfSamplingPoints + 0.5)
    #Norm is only important for deriving absolute absorbtion coefficient, this is however not possible with this form of gridrec
    C = 7.0
    norm = float(np.sqrt(np.pi/2/C/lmbda)) 
    lookupTableOfConvolventInRealSpace=np.zeros(2*numberOfSamplingPoints)
    for samplingPoint in range (0, numberOfSamplingPoints):
        lookupTableOfConvolventInRealSpace[numberOfSamplingPoints + samplingPoint] = norm/convolvent(samplingPoint*scaleRatio)
        lookupTableOfConvolventInRealSpace[numberOfSamplingPoints - (samplingPoint+1)] = norm/convolvent(samplingPoint*scaleRatio)
    inverseFFTCorrectionFactorMatrix = np.outer(lookupTableOfConvolventInRealSpace, lookupTableOfConvolventInRealSpace)
    return inverseFFTCorrectionFactorMatrix


def postCorrect(reconstruction):
    numberOfSamplingPoints = reconstruction.shape[0]//2
    inverseFFTCorrectionFactorMatrix = setupInverseFFTCorrectionFactor(numberOfSamplingPoints)
    return reconstruction*inverseFFTCorrectionFactorMatrix

    
