# Literature Survey for Computer Tomography


## Ptychograpy and Tomograpy

[Bayesian Experimental Design for Computed Tomography with the Linearised Deep Image Prior](https://arxiv.org/abs/2207.05714)

[TomoGAN: Low-Dose Synchrotron X-Ray Tomography with Generative Adversarial Networks](https://arxiv.org/abs/1902.07582)

[Accelerated deep self-supervised ptycho-laminography for three-dimensional nanoscale imaging of integrated circuits](https://arxiv.org/abs/2304.04597)

[Noise-resilient deep learning for integrated circuit tomography](https://opg.optica.org/oe/fulltext.cfm?uri=oe-31-10-15355&id=529374)

[Attentional Ptycho-Tomography (APT) for three-dimensional nanoscale X-ray imaging with minimal data acquisition and computation time](https://www.nature.com/articles/s41377-023-01181-8) [Arxiv](https://arxiv.org/abs/2212.00014)


[Joint ptycho-tomography with deep generative priors](https://iopscience.iop.org/article/10.1088/2632-2153/ac1d35/meta)

* good description of the forward process
* solving pychograpy and tomograpy in a single objectivce
* the joint objective is split into subproblems: pytchograpic phase retrivel, tomograpyic reconstruction and regularization
* proposes to use a learned (pre-trained?) prior for denoising
* [Plug and Play (PnP)](https://engineering.purdue.edu/~bouman/Plug-and-Play/webdocs/GlobalSIP2013a.pdf) priors (not clear?)
* demonstrated on chip data

[Direct 3D Tomographic Reconstruction and Phase-Retrieval of Far-Field Coherent Diffraction Patterns](https://arxiv.org/abs/1808.02109)
* combine phase-retrivial in a tomograpic framework
* directly reconstruct in 3D
* iterative optimization using Levenberg-Marquardt algorithm
* Sampling overlap is achieved with rotation only instead of 2d patch scanning overlap

[Compressive Ptychography using Deep Image and Generative Priors](https://arxiv.org/abs/2205.02397)

* 2d X-ray ptychography 
* goal is to reduce the overlap of the patches required
* instead of reconstrucing the phase direcitly, this paper reconstructs be optimizing over the latent space of a Gaussian
* further, optimize over network prior and latent space jointly (not exactly clear how this works?)
* only tests on images, but the methodology could be relevant
* algorithm is a bit adhoc

[Three-dimensional nanoscale reduced-angle ptycho-tomographic imaging with deep learning (RAPID)](https://elight.springeropen.com/articles/10.1186/s43593-022-00037-9?trk=public_post_comment-text)
* learns a prior from scanning part of the images, high fidelty scan is used as ground truth
* reduces the number of scans/angles required for subsequent portions of the object
* unet architecture
* reduces number of angles from 349 to 21


## Kernel Learning

[Deep Kernel Representation for Image Reconstruction in PET](https://arxiv.org/abs/2110.01174)


## Diffusion-Based Approaches

[Ho et al; 2020. Denoising Diffusion Probabilistic Models](https://arxiv.org/abs/2006.11239)

[Song et al; 2020. Score-Based Generative Modeling through Stochastic Differential Equations](https://arxiv.org/abs/2011.13456)

[Song et al; 2020. Solving Inverse Problems with Latent Diffusion Models via Hard Data Consistency](https://arxiv.org/abs/2307.08123)


### CT-Specific

[Solving Inverse Problems in Medical Imaging with Score-Based Generative Models](https://arxiv.org/abs/2111.08005)

[Diffusion Probabilistic Priors for Zero-Shot Low-Dose CT Image Denoising](https://arxiv.org/abs/2305.15887)

[Learning Controllable 3D Diffusion Models from Single-view Images](https://arxiv.org/abs/2304.06700)

[DOLCE: A Model-Based Probabilistic Diffusion Framework for Limited-Angle CT Reconstruction](https://openaccess.thecvf.com/content/ICCV2023/papers/Liu_DOLCE_A_Model-Based_Probabilistic_Diffusion_Framework_for_Limited-Angle_CT_Reconstruction_ICCV_2023_paper.pdf)

## NeRF: Neural Radiance Fields


[3D Gaussian Splatting for Real-Time Radiance Field Rendering](https://repo-sam.inria.fr/fungraph/3d-gaussian-splatting/)


## Alignment of sinograms

[Alignment methods for nanotomography with deep subpixel accuracy](https://opg.optica.org/oe/fulltext.cfm?uri=oe-27-25-36637&id=423764)

