The main results are reproduced using the following command, where the `--model` argument specifies the model to be used (any of `Diffusion`, `Laplace`, `Swag`, `Bootstrap`), the `--dataset` argument specifies the dataset to be used (any of `Lamino`, `Lung`, `Composite`), and the `--acquisition` argument specifies the acquisition function to be used (`uniform`, `variance`, `gauss_entropy`, `committee`). The `--dataset.indices` argument specifies the index of the image to be used in the dataset. 

Note that the code is provided for inspection purposes. A complete, executable version including all checkpoints will be made available upon publication.

```bash
python /scratch/snx3000/.../chip/chip-project/chip/evaluation/generative_active_learning.py --logging.path=/scratch/snx3000/.../chip/runs/ --experiment=exp_name --experiment.num_iterations=100 --model=$model --model.iterative.reset_every_step --model.path=/scratch/snx3000/.../chip/runai/checkpoints --model.laplace.matrix_path=/scratch/snx3000/.../chip/runai/checkpoints --model.laplace.hydra_path=/scratch/snx3000/.../chip/bayes_dip_mods/experiments/hydra_cfg/ --dataset=$dataset --dataset.path=/scratch/snx3000/.../chip/runai/data --dataset.indices=0,1,2,3,4,5 --acquisition.score=$acquisition --model.laplace.train_iterations=500 --model.laplace.train_lr=0.0003 --model.laplace.reconstruction=dip_recon --model.swag.subsample=10 --model.laplace.optimize_iterations=3
```

For the results using the pre-scan, we use the following command:
    
```bash
python /scratch/snx3000/.../chip/chip-project/chip/evaluation/generative_active_learning.py --logging.path=/scratch/snx3000/.../chip/runs/ --experiment=exp_name --experiment.num_iterations=100 --model=$model --model.iterative.reset_every_step --model.path=/scratch/snx3000/.../chip/runai/checkpoints --model.laplace.matrix_path=/scratch/snx3000/.../chip/runai/checkpoints --model.laplace.hydra_path=/scratch/snx3000/.../chip/bayes_dip_mods/experiments/hydra_cfg/ --dataset=$dataset --dataset.path=/scratch/snx3000/.../chip/runai/data --dataset.indices=0,1,2,3,4,5 --acquisition.score=$acquisition --model.laplace.train_iterations=500 --model.laplace.train_lr=0.0003 --acquisition.init.num_lr_angles=180 --model.laplace.unet_input=fbp --model.laplace.reconstruction=dip_recon --model.swag.subsample=10 --model.laplace.optimize_iterations=3
```
