#!/bin/bash

DIR_EXP="PUT HERE ROOT OF YOUR RESULTS DIRECTORY TREE"
DIR_GIN=configs
TF_CPP_MIN_LOG_LEVEL=3
PYTHONWARNINGS=ignore


for model in $(cd $DIR_GIN/models && ls *.gin)
do
    for k_true in 2 4 6 7
        do
            for i in 1 2 3
            do
                # Extracting experiment name
                OLD_IFS=$IFS
                IFS='.'
                read -a exp_name <<< "$model"
                IFS=$OLD_IFS
                EXP_NAME=${exp_name[0]}
                # Get estimated mean k and round to nearest integer
                train_result_dir="${DIR_EXP}/${EXP_NAME}_k_${k_true}_seed_${i}_k_${k_true}/model/results/json/train_results.json"
                k_est=$(cat $train_result_dir | jq .mean_k_hat)
                k_est=$(printf "%.f\n" "$k_est")
                echo "Training ${EXP_NAME} with k_true=${k_true}, k_est=${k_est} and ${i}-th seed"
                dlib_reproduce_weakly_supervised \
                --output_directory="${DIR_EXP}/${EXP_NAME}_k_${k_true}_seed_${i}_k_${k_true}" \
                --model_dir="${DIR_EXP}/${EXP_NAME}_k_${k_true}_seed_${i}_k_${k_true}" \
                --gin_postprocess_config_glob=$DIR_GIN/postprocess/distribution.gin \
                --gin_evaluation_config_glob=$DIR_GIN/evaluation/weak_downstream_task*.gin \
                --overwrite=True \
                --gin_bindings="weak_downstream_task.k_est=${k_est}" \
                --gin_bindings="weak_downstream_task.k_true=${k_true}"
        done
    done
done
