#!/bin/bash

# module load cuda/10.0.130
# module load cudnn/7.6.4
# 
# source activate dis_lib

conda activate YOUR CONDA ENV HERE

DIR_EXP="PUT YOUR DESIRED OUTPUT PATH HERE"
DIR_GIN=configs
TF_CPP_MIN_LOG_LEVEL=3
PYTHONWARNINGS=ignore
mname="groupVAE_HG.gin"
learning_rates=(0.000001)
use_log_kl_values=(True)
use_tanh_act_values=(False)
clip_logits_w_values=(0)
gamma_values=(1.0)
gs_tau_final=(0.01)
gs_tau_init_mult=(100.0)
t_annealing_values=("@exp_annealing")
t_start_annealing=(0)
t_annealing_steps=(50000)
hg_mc_samples=(5)
reparam_hg=(True)

use_neuralsort_values=(True)
nsort_fc_input_values=(False)
reparam_neuralsort=(False)
mult_tau_neuralsort_values=(1.0)

k_values=(2 4 6 7)
seeds=(1 2 3)

# for model in $(cd $DIR_GIN/models && ls *.gin)
for seed in ${seeds[@]}
do
for model in ${mname}
do
for lr in ${learning_rates[@]}
do
for tau_final in ${gs_tau_final[@]}
do
for tau_mult in ${gs_tau_init_mult[@]}
do
for a_func in ${t_annealing_values[@]}
do
for a_start in ${t_start_annealing[@]}
do
for a_steps in ${t_annealing_steps[@]}
do
for gamma in ${gamma_values[@]}
do
for use_log_kl in ${use_log_kl_values[@]}
do
for use_tanh_act in ${use_tanh_act_values[@]}
do
for clip_w in ${clip_logits_w_values[@]}
do
for nsort_fc in ${nsort_fc_input_values[@]}
do
for use_nsort in ${use_neuralsort_values[@]}
do
for rep_w in ${reparam_hg[@]}
do
for rep_s in ${reparam_neuralsort[@]}
do
for mc in ${hg_mc_samples[@]}
do
for k in ${k_values[@]}
do
for m_tau_ns in ${mult_tau_neuralsort_values[@]}
do
    # Extracting experiment name
    OLD_IFS=$IFS
    IFS='.'
    read -a exp_name <<< "$model"
    IFS=$OLD_IFS
    EXP_NAME="${exp_name[0]}/tanh_${use_tanh_act}_clipW_${clip_w}_logkl_${use_log_kl}_useNsort_${use_nsort}_nsortFC_${nsort_fc}"
    EXP_NAME="${EXP_NAME}/reparamW_${rep_w}_reparamS_${rep_s}/lr_${lr}_gamma${gamma}_mc${mc}"
    EXP_NAME="${EXP_NAME}/temp${tau_final}_${a_func:1}_initMult_${tau_mult}_start${a_start}_steps${a_steps}_multTauNS${m_tau_ns}"
    echo "Training ${EXP_NAME}"
    dlib_reproduce_weakly_supervised --output_directory="${DIR_EXP}/${EXP_NAME}_k_${k}" \
                                     --gin_postprocess_config_glob=$DIR_GIN/postprocess/*.gin \
                                     --gin_evaluation_config_glob=$DIR_GIN/evaluation/*.gin \
                                     --overwrite=True \
                                     --pipeline_seed=${seed}\
                                     --gin_model_config_dir=$DIR_GIN/models \
                                     --gin_model_config_name=$model \
                                     --gin_bindings="AdamOptimizer.learning_rate=${lr}" \
                                     --gin_bindings="dynamics.k=${k}" \
                                     --gin_bindings="group_vae_hg.gamma=${gamma}" \
                                     --gin_bindings="group_vae_hg.mc_samples=${mc}" \
                                     --gin_bindings="hgeom_selector.tau=${tau_final}" \
                                     --gin_bindings="hgeom_selector.tau_init_mult=${tau_mult}" \
                                     --gin_bindings="hgeom_selector.mult_tau_neuralsort=${m_tau_ns}" \
                                     --gin_bindings="hgeom_selector.temperature_annealing=${a_func}" \
                                     --gin_bindings="hgeom_selector.start_annealing=${a_start}" \
                                     --gin_bindings="hgeom_selector.annealing_steps=${a_steps}" \
                                     --gin_bindings="hgeom_selector.use_tanh_act=${use_tanh_act}" \
                                     --gin_bindings="hgeom_selector.clip_logits_w=${clip_w}" \
                                     --gin_bindings="hgeom_selector.use_log_kl=${use_log_kl}" \
                                     --gin_bindings="hgeom_selector.neuralsort_fc_input=${nsort_fc}" \
                                     --gin_bindings="hgeom_selector.use_neuralsort=${use_nsort}" \
                                     --gin_bindings="hgeom_selector.reparameterize_w=${rep_w}" \
                                     --gin_bindings="hgeom_selector.reparameterize_s=${rep_s}"
done
done
done
done
done
done
done
done
done
done
done
done
done
done
done
done
done
done
done
