import os
import random
import argparse
import datetime


def parse_args(env=None):
    parser = argparse.ArgumentParser(
        description='args rl', formatter_class=argparse.RawDescriptionHelpFormatter)

    # prepare parameters
    parser.add_argument("--algo", type=str,
                        default='pcrl', choices=["pcrl"])
    parser.add_argument("--env", type=str,
                        default='Alien-v5', help="specify the name of environment")
    parser.add_argument("--num_envs", type=int,
                        default=1, help="number of environment")
    parser.add_argument("--times", type=int,
                        default=2, help="default train times")
    parser.add_argument("--seed", type=int,
                        default=None, help="seed, random seed if None")
    parser.add_argument("--cuda", action='store_false',
                        default=True, help="by default True, will use GPU to train; or else will use CPU;")
    parser.add_argument("--cuda_deterministic", action='store_false',
                        default=True, help="by default, make sure random seed effective. if set, bypass such function.")
    parser.add_argument("--eval_freq", type=int,
                        default=5000, help="frequency to evaluate")
    parser.add_argument("--save", action="store_true",
                        default=False, help="save model parameters per log_freq")
    parser.add_argument("--video", action="store_true",
                        default=False, help="capture video while evaluating agent")
    parser.add_argument("--resize", type=int,
                        default=84, help="")

    args = parser.parse_args()
    if env:
        args.env = env
    args.env = "ALE/" + args.env
    assert args.num_envs == 1, "vectorized envs are not supported at the moment"
    args.time = str(datetime.datetime.now().replace(microsecond=0).strftime("%Y%m%d-%H%M"))
    if not args.seed:
        args.seed = random.randint(0, 100000)
    args.save_path = os.path.join("results", args.env, args.algo)
    if not os.path.isdir(args.save_path):
        args.save_path = os.path.join(args.save_path, "run1")
        os.makedirs(args.save_path)
    else:
        files = os.listdir(args.save_path)
        nums = [0]
        for file in files:
            if file.startswith("run"):
                nums.append(int(file.replace("run", "")))
        args.save_path = os.path.join(args.save_path, "run" + str(max(nums) + 1))
        os.makedirs(args.save_path)

    args.model_path = os.path.join(args.save_path, "models")
    args.log_path = os.path.join(args.save_path, "logs.txt")
    args.tb_path = args.save_path

    args.args_path = os.path.join(args.save_path, "args.yaml")
    if args.save and not os.path.isdir(args.model_path):
        os.makedirs(args.model_path)
    if args.video and not os.path.isdir(args.video_path):
        os.makedirs(args.video_path)

    if args.algo == "curl":
        args.resize=100

    return args
